/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <functional>
#include <list>

#include "fairrsh.h"
#include "state.h"
#include "module.h"
#include "autobuild.h"

DECLARE_string(opening);
DECLARE_bool(bandit);

namespace fairrsh {

namespace strategy {

  class StrategyModule : public Module {
    RTTR_ENABLE(Module)
      bool spawnedBOTask_ = false;
      std::shared_ptr<AutoBuildTask> selectBO(
          State* state,
          tc::BW::Race enemyRace,
          const std::string& mapName,
          const std::string& enemyName,
          UpcId srcUpcId);

     public:
      virtual ~StrategyModule() = default;

      virtual void step(State* state) override;
      virtual void onGameEnd(State* s) override;
  };

} // namespace strategy

} // namespace fairrsh
