/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"
#include "upc.h"

namespace fairrsh {
/**
 * A combat module that controls squads of units, and directly issues orders,
 * bypassing the combatmicro module. Intended to replace Combat + CombatMicro
 */
class SquadCombatModule : public Module {
  RTTR_ENABLE(Module)

 public:
  struct UnitState {
    Unit* target = nullptr;
    Unit* attacking = nullptr;
    bool traveling = false;
    Position destination = {-1, -1};
    int lastTarget = -1;
    int lastMove = -1;
    int burrowing = 0;
    int mutaliskTurning = false;
  };

  struct EnemyState {
    int damages = 0;
    int lastRepairing = false;
  };

  virtual void step(State* s) override;

 protected:
  bool
  formNewSquad(State* s, std::shared_ptr<UPCTuple> sourceUpc, int sourceUpcId);
  void updateTask(State* s, std::shared_ptr<Task> task);
  // POST-9/1 TODO These should be on the blackboard
  std::unordered_map<Unit const*, UnitState> unitStates_;
  std::unordered_map<Unit const*, EnemyState> enemyStates_;
};

} // namespace fairrsh
