/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "blackboard.h"
#include "modules/lambda.h"
#include "state.h"

namespace fairrsh {

/**
 * A simple utility module that runs a user-supplied function once per game.
 */
class OnceModule : public LambdaModule {
  RTTR_ENABLE(LambdaModule)

 public:
  struct SpawnInfo {
    SpawnInfo(int t, int x, int y)
        // Ok to throw here if type conversion fails
        : type(tc::BW::UnitType::_from_integral(t)),
          x(x),
          y(y){};
    tc::BW::UnitType type;
    // Note: x/y is in walktiles.
    int x;
    int y;
  };

 public:
  OnceModule(StepFunction func, std::string name = std::string());
  virtual ~OnceModule() = default;

  static std::shared_ptr<Module> makeWithCommands(
      std::vector<tc::Client::Command> commands,
      std::string name = std::string());
  static std::shared_ptr<Module> makeWithSpawns(
      std::vector<SpawnInfo> spawns,
      std::string name = std::string());
  static std::shared_ptr<Module> makeWithEnemySpawns(
      std::vector<SpawnInfo> spawns,
      std::string name = std::string());

  virtual void step(State* state) override;

 private:
  std::string key_;
};

} // namespace fairrsh
