/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

namespace fairrsh {

struct Unit;

/**
 * A module that does micro for the mean ling rush buildorder.
 * It is usually disabled, and requires the MeanLingRushEnabled blackboard key
 * too be activated.
 */
class MeanLingRushModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual void step(State* s) override;

 protected:
  UpcId findSourceUpc(State* s);

  void process(State* state, int srcUpcId);

  Position lastTarget;

  std::unordered_map<Unit*, int> noOrderUntil;
  std::unordered_map<Unit*, int> lastTargetInRange;
};

} // namespace fairrsh
