/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

namespace fairrsh {

/**
 * A simple helper module that calls a user-supplied step function
 */
class LambdaModule : public Module {
  RTTR_ENABLE(Module)

 public:
  using StepFunction = std::function<void(State*)>;

  LambdaModule(StepFunction fn, std::string name = std::string());
  virtual ~LambdaModule() = default;

  virtual void step(State* state) override;

 protected:
  StepFunction fn_;
};

} // namespace fairrsh
