/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "modules/lambda.h"

namespace fairrsh {

RTTR_REGISTRATION {
  // Don't register a constructor for this class since its purpose is ad-hoc
  // instantation with a user-supplied function.
  rttr::registration::class_<LambdaModule>("LambdaModule")(
      metadata("type", rttr::type::get<LambdaModule>()));
}

LambdaModule::LambdaModule(StepFunction fn, std::string name)
    : Module(), fn_(fn) {
  setName(std::move(name));
}

void LambdaModule::step(State* state) {
  fn_(state);
}

} // namespace fairrsh
