/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "autobuild.h"
#include "fairrsh.h"

namespace fairrsh {

namespace autobuild {

class GenericAutoBuildModule : public AutoBuildModule {
  RTTR_ENABLE(Module)
    Blackboard* board = nullptr;

  public:
    virtual ~GenericAutoBuildModule() = default;

    virtual void checkForNewUPCs(State* state) override;

    virtual std::shared_ptr<AutoBuildTask> createTask(int srcUpcId) override;
};

} // name space autobuild

} // namespace fairrsh
