/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "genericautobuild.h"
#include "fairrsh.h"
#include <algorithm>
#include <stdexcept>

#include "../buildorders/registry.h"

#include <gflags/gflags.h>

DECLARE_string(build);

namespace fairrsh {

namespace autobuild {

RTTR_REGISTRATION {
  rttr::registration::class_<GenericAutoBuildModule>("GenericAutoBuildModule")(
      metadata("type", rttr::type::get<GenericAutoBuildModule>()))
      .constructor();
}

std::shared_ptr<AutoBuildTask> GenericAutoBuildModule::createTask(
    int srcUpcId) {
  auto task = board->taskForId(srcUpcId);
  if (task != nullptr)
    return nullptr; // for now
  const UPCTuple& upctuple = *board->upcs()[srcUpcId];
  std::vector<DefaultAutoBuildTask::Target> targets;
  // if (upctuple->command[Command::Create] == 1.0f) : TODO priorities
  const std::unordered_map<BuildType const*, float>& ct = upctuple.createType;
  auto min_prob =
      std::min_element(ct.begin(), ct.end(), [](auto ct1, auto ct2) {
        return ct1.second < ct2.second;
      })->second;
  assert(min_prob > 0.f); // otherwise ignore zeros
  for (auto& bt_p : upctuple.createType) {
    auto ratio = static_cast<int>(std::ceil(bt_p.second / min_prob));
    targets.emplace_back(bt_p.first, ratio);
  }
  throw std::runtime_error("waa");
  return std::make_shared<DefaultAutoBuildTask>(srcUpcId, std::move(targets));
}

void GenericAutoBuildModule::checkForNewUPCs(State* state) {
  this->board = state->board();
  auto tasks = board->tasksOfModule(this);
  // for (auto& upcs : state->board()->upcsWithCommand(Command::Create, 0.01f))
  // { : TODO priorities between tasks
  for (auto& upcs : state->board()->upcsWithSharpCommand(Command::Create)) {
    if (!upcs.second->createType.empty()) {
//      auto task = createTask(upcs.first);
//      if (task == nullptr)
//        continue;
//      board->postTask(task, this);
//      tasks.push_back(task);
    } else { // Create = 1 but doesn't say what to Create
      auto ts = board->tasksOfModule(nullptr);
      if (ts.empty()) {
        continue;
      } else {
        if (ts.size() > 1) {
          LOG(ERROR) << "More than one task with nullptr owner module";
        }
        board->consumeUPCs({upcs.first}, this);
        board->changeTaskOwnership(ts[0].get(), nullptr, this);
        tasks.push_back(ts[0]);
      }
    }
  }
  for (auto& task : board->tasksOfModule(this)) {
    if (task->finished()) { // they're not supposed to finish now
      // but just in case we can keep this (to relaunch a BO if stopped)
      board->markTaskForRemoval(task);

      auto upc = std::make_shared<UPCTuple>();
      upc->scale = 1;
      upc->command[Command::Create] = 1;
      auto upcId = board->postUPC(std::move(upc), -1, this); // fake UPC

      board->consumeUPC(upcId, this);

      auto boTask = buildorders::createTask(upcId, FLAGS_build);
      board->postTask(std::move(boTask), this);
    }
  }
}

} // namespace autobuild

} // namespace fairrsh
