/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

namespace fairrsh {

/**
 * This module posts create UPCs for the relevant units of the "5 pool" opening
 * for Zerg.
 *
 * See http://wiki.teamliquid.net/starcraft/5_Pool_(vs._Protoss)
 */
class FivePoolModule : public Module {
  RTTR_ENABLE(Module)

 public:
  FivePoolModule();
  virtual ~FivePoolModule() = default;

  virtual void step(State* state) override;

 protected:
  std::vector<const BuildType*> builds_;
};

} // namespace fairrsh
