/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"
#include "unitsinfo.h"

namespace fairrsh {

/**
 * Basic defence against harassment
 */
class DefendBaseModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual ~DefendBaseModule() = default;

  virtual void step(State* s) override;

  // configuration of the defense
  void setDefenseParams(float, float, bool onAttackBuilding = false, bool onAttackWorker = false);

 protected:
  bool tooFar(State* state, Unit* unit);
  float minDist(State* state, Unit* unit);
  Unit* findWorker(State* state, Unit* target, std::unordered_set<Unit*>&);
  bool buildingAttacked(State* state);
  bool workerAttacked(State* state);
  // basic task/upc management
  void consumeUPC(State* state, UpcId upcId, std::shared_ptr<UPCTuple> upc);
  void createUPC(State* state, const Position& loc);
  void createUPCs(State* state);

  float minDistToBuildings_ = 50;
  int maxNbWorkers_ = 1;
  bool onAttackBuildings_ = false;
  bool onAttackWorkers_ = false;
};

} // namespace fairrsh
