/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <functional>
#include <list>

#include "fairrsh.h"
#include "module.h"

namespace fairrsh {

struct UPCTuple;

/**
 * Generates separate, unspecific UPCTuples for Create, Gather and Delete/Move.
 *
 * This module should be used as the first or second module (after TopModule) in
 * a Player.
 */
class CreateGatherAttackModule : public Module {
  RTTR_ENABLE(Module)

 public:
  CreateGatherAttackModule() : Module() {}

  virtual void step(State* s);

 private:
  std::shared_ptr<UPCTuple> create_;
  std::shared_ptr<UPCTuple> gather_;
  std::shared_ptr<UPCTuple> attack_;
};

} // namespace fairrsh
