/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

namespace fairrsh {

struct Unit;

/**
 * Unit micro-management for combats
 */
class CombatMicroModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual void step(State* s) override;

 protected:
  struct HealthInfo {
    int hp;
    int shield;
  };

  void consumeUPC(State* s, int upcId, std::shared_ptr<UPCTuple> upc);
  void updateTasks(State* s);
  void updateTarget(
      std::shared_ptr<Task> task,
      std::unordered_map<Unit*, HealthInfo>* targetHealth);
};

} // namespace fairrsh
