/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"
#include "upc.h"

namespace fairrsh {

/**
 * A combat module that controls squads of units.
 */
class CombatModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual void step(State* s) override;

 protected:
  bool
  formNewSquad(State* s, std::shared_ptr<UPCTuple> sourceUpc, int sourceUpcId);
  void updateTask(State* s, std::shared_ptr<Task> task);
};

} // namespace fairrsh
