/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "fairrsh.h"
#include "module.h"
#include "state.h"

#include <deque>
#include <list>
#include <vector>
#include <unordered_map>

namespace fairrsh {

/**
 * This module consumes a Create UPC with a sharp createType and attempts to
 * create it. Units and position are optional; by default, an appropriate and
 * not-so-busy worker or producer will be selected.
 * A build task will be created for every UPC consumed, regardless of current
 * resources, and it will continually be attempted to be built. Tasks never
 * fail, but may be cancelled. Items will be created in the order UPCs are
 * consumed, unless we have spare resources which may allow later UPCs to be
 * fulfilled first.
 */
class BuilderModule : public Module {
  RTTR_ENABLE(Module)

 public:
  BuilderModule() {}
  virtual ~BuilderModule() = default;

  virtual void step(State* s) override;

  std::unordered_map<Unit*, std::tuple<int, const BuildType*, Position>> recentAssignedBuilders;

 protected:
  std::shared_ptr<Task>
  createTask(State* s, std::shared_ptr<UPCTuple> upc, int upcId);

  int lastIncomeHistoryUpdate_ = 0;
  std::deque<int> mineralsHistory_;
  std::deque<int> gasHistory_;
  double currentMineralsPerFrame_ = 0.0;
  double currentGasPerFrame_ = 0.0;
};

} // namespace fairrsh
