/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <glog/logging.h>
#include <BOSS.h>

#include "buildtype.h"

namespace fairrsh {
namespace bosshelpers {

// converts BOSS action type to fairrsh build type
inline const fairrsh::BuildType* bossAction2BuildType(
  const BOSS::ActionType& bossAction) {
  if (bossAction.isUnit()) {
    return fairrsh::getBuildType(bossAction.getUnitType());
  } else if (bossAction.isTech()) {
    return fairrsh::getBuildType(bossAction.getTechType());
  } else if (bossAction.isUpgrade()) {
    return fairrsh::getBuildType(bossAction.getUpgradeType());
  }
  LOG(ERROR) << "could not convert BOSS action " << bossAction
             << " to build type";
  return nullptr;
}

} // namespace bosshelpers
} // namespace fairrsh
