/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <list>

#include <torchcraft/client.h>

#include "fairrsh.h"

namespace fairrsh {

class Player;
class State;
// Useful for derived classes
class Task;
struct UPCTuple;

/**
 * Interface for bot modules.
 *
 * Use Module::make<T>(args) to construct a new module instance of a given type.
 */
class Module {
  RTTR_ENABLE()

 public:
  virtual ~Module() = default;

  template <typename T, typename... Args>
  static std::shared_ptr<T> make(Args&&... args) {
    auto m = std::make_shared<T>(std::forward<Args>(args)...);
    if (m->name().empty()) {
      m->setName(makeName(rttr::type::get<T>()));
    }
    return m;
  }
  static std::shared_ptr<Module> make(std::string const& typeName);

  virtual void setPlayer(Player* p) {
    player_ = p;
  };

  void setName(std::string name);
  std::string name();
  static std::string makeName(rttr::type const& type);

  virtual void step(State* s);
  //  virtual void backward(State* s) {} // TODO
  virtual void onGameEnd(State* s) {}

 protected:
  Module();

  void postCommandForSteps(tc::Client::Command cmd, int steps);

  Player* player_;
  std::string name_;
  std::list<std::pair<tc::Client::Command, int>> commands_;
};

} // namespace fairrsh
