/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#ifdef _MSC_VER
// On Windows, glog functions are annotated for DLLS but we want to link
// statically.
#define GOOGLE_GLOG_DLL_DECL
#endif // _MSC_VER

#include "basetypes.h"

#include <rttr/registration>
#include <rttr/type>
#include <torchcraft/state.h>

#include <string>
#include <chrono>

/**
 * The bot namespace.
 *
 * All bot-related code should live within this namespace.
 */
namespace fairrsh {

namespace tc = ::torchcraft;

using Duration = std::chrono::nanoseconds;
// We want a steady high-resolution clock (ideally with sub-ms precision)
// TODO: Use a different clock on systems where steady_clock's resolution is
// too low (VS2013?)
using hires_clock = std::chrono::steady_clock;

void init();
void initLogging(
    const char* execName,
    std::string logSinkDir,
    bool logSinkToStderr);
void shutdown(bool logSinkToStderr);

/// Set a frame number to prefix log messages with
void setLoggingFrame(int frame);

/// Reset the frame number for log messages
void unsetLoggingFrame();

} // namespace fairrsh
