/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <array>
#include <vector>

namespace fairrsh {

struct BuildType;
struct Unit;

class CombatSim {
 public:
  struct SimUnit {
    int x = 0;
    int y = 0;
    double hp = 0.0;
    double shields = 0.0;
    int armor = 0;
    int maxSpeed = 0;
    bool flying = false;
    const BuildType* type = nullptr;
    SimUnit* target = nullptr;
    bool targetInRange = false;

    int cooldownUntil = 0;
    int groundDamage = 0;
    int airDamage = 0;
    int groundDamageType = 0;
    int airDamageType = 0;
    int groundRange = 0;
    int airRange = 0;
  };

  struct Team {
    double startHp = 0.0;
    double endHp = 0.0;
    std::vector<SimUnit> units;
  };

  std::array<Team, 2> teams;

  void addUnit(Unit* u);

  void run(int frames);
};
}
