/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBOzvp10hatch : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  bool buildExtractor = false;
  bool hasBuiltExtractor = false;
  int hurtSunkens = 0;
  bool hasSunken = false;
  bool wasAllinRushed = false;
  int currentFrame = 0;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    state->board()->post("kMinScoutFrame", 15 * 60 * 4);

    bool attack = false;
    if (state->currentFrame() >= 15 * 60 * 14) {
      attack = armySupply > enemyArmySupply + 8.0 - enemyAttackingArmySupply;
      if (bases > 3 && armySupply < enemyArmySupply + 16.0) {
        attack = false;
      }
      if (state->currentFrame() >= 15 * 60 * 30) {
        attack = true;
      }
    }
    if (state->currentFrame() < 24 * 60 * 8 && enemyArmySupply < 12.0 && !wasAllinRushed) {
      attack = true;
    }
    if ((wasAllinRushed && armySupply > enemyArmySupply) || weArePlanningExpansion) {
      attack = true;
    }
    if (enemyStaticDefenceCount || enemyHasExpanded ||
        state->unitsInfo().myUnitsOfType(Zerg_Hydralisk).empty()) {
      if (enemyStaticDefenceCount >= 8) {
        attack = state->currentFrame() >= 15 * 60 * 22;
      }
      if (enemyArmySupply < 8.0 && enemyStaticDefenceCount < 4) {
        attack = true;
      }
    }
    state->board()->post("TacticsAttack", attack);

    auto st = getMyState(state);
    if (!hasBuiltExtractor && countPlusProduction(st, Zerg_Drone) == 9 &&
        countPlusProduction(st, Zerg_Overlord) == 1) {
      buildExtractor = true;
      for (Unit* u : state->unitsInfo().myBuildings()) {
        if (u->type == Zerg_Extractor && !u->completed()) {
          state->board()->postUPC(
              utils::makeSharpUPC(u, Command::Cancel), -1, module);
          hasBuiltExtractor = true;
        }
      }
    } else {
      buildExtractor = false;
    }

    if (!wasAllinRushed && state->unitsInfo().myWorkers().size() < 22) {
      double totalEnemyArmySupply = 0.0;
      for (Unit* u : state->unitsInfo().allUnitsEver()) {
        if (u->isEnemy) {
          totalEnemyArmySupply += u->type->supplyRequired;
        }
      }
      if (totalEnemyArmySupply >= 16.0) {
        wasAllinRushed = true;
      }
    }

    hurtSunkens = 0;
    for (Unit* u :
         state->unitsInfo().myCompletedUnitsOfType(Zerg_Sunken_Colony)) {
      if (u->unit.health < u->type->maxHp / 2) {
        ++hurtSunkens;
      }
    }

    if (!hasSunken) {
      hasSunken = !state->unitsInfo().myUnitsOfType(Zerg_Sunken_Colony).empty();
    }
    currentFrame = state->currentFrame();
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    st.autoBuildRefineries = countPlusProduction(st, Zerg_Extractor) == 0 ||
        st.frame >= 15 * 60 * 11;

    if (st.frame < 15 * 60 * 4 + 15 * 50) {
      if (myCompletedHatchCount >= 2 && nextStaticDefencePos != Position()) {
        if (!hasSunken) {
          buildSunkens(st, 2);
          return;
        }
      }
    }

    if (st.usedSupply[tc::BW::Race::Zerg] < 185.0 ||
        countPlusProduction(st, Zerg_Mutalisk) >= 20) {
      build(Zerg_Zergling);
      build(Zerg_Hydralisk);
      if (groundArmySupply >= 25.0 && st.workers >= 44) {
        buildN(Zerg_Mutalisk, 6);
      }
      if (has(st, Zerg_Spire)) {
        if (enemyReaverCount) {
          if (countPlusProduction(st, Zerg_Mutalisk) < enemyArmySupply - enemyAntiAirArmySupply * 1.5 + enemyReaverCount) {
            build(Zerg_Mutalisk);
          }
        }
        if (countPlusProduction(st, Zerg_Scourge) < std::min(enemyAirArmySupply, 4.0)) {
          build(Zerg_Scourge);
        }
      }
    } else {
      build(Zerg_Mutalisk);
    }

    if (countPlusProduction(st, Zerg_Hydralisk) >= 40.0 &&
        (armySupply > enemyArmySupply || armySupply >= 80.0)) {
      buildN(Zerg_Mutalisk, 6);
      buildN(Zerg_Scourge, std::min((int)enemyAirArmySupply, 10));
    }

    if (countPlusProduction(st, Zerg_Zergling) >= 10) {
      upgrade(Metabolic_Boost);
    }

    if (armySupply > enemyArmySupply) {
      if (countProduction(st, Zerg_Drone) == 0) {
        buildN(Zerg_Drone, 66);
      }
      if (armySupply > enemyArmySupply + enemyAttackingArmySupply &&
          countProduction(st, Zerg_Drone) < 3) {
        buildN(Zerg_Drone, 45);
      }
    }

    if (st.workers >= 40) {
     upgrade(Pneumatized_Carapace);
    }

    if (st.workers >= 30 && ((armySupply > enemyArmySupply && !wasAllinRushed) || st.workers >= 42)) {
      buildN(Zerg_Lair, 1) && buildN(Zerg_Spire, 1);
    }

    if (armySupply > enemyArmySupply + 8.0 || armySupply >= 20.0) {
      if (st.workers >= 40) {
        upgrade(Zerg_Carapace_1) && upgrade(Zerg_Carapace_2) &&
            upgrade(Zerg_Carapace_3);
      }
      upgrade(Zerg_Missile_Attacks_1) && upgrade(Zerg_Missile_Attacks_2) &&
          upgrade(Zerg_Missile_Attacks_3);
    }

    if (bases < (armySupply >= 20.0 && armySupply > enemyArmySupply + 8.0
                     ? 4
                     : 3) &&
        !st.isExpanding && canExpand &&
        armySupply >= std::min(enemyArmySupply, 12.0)) {
      build(Zerg_Hatchery, nextBase);
    }
    if (armySupply > enemyArmySupply) {
      buildN(Zerg_Drone, 24 + std::max(enemyStaticDefenceCount - 3, 0) * 4);
    } else {
      buildN(Zerg_Drone, 24 + enemyStaticDefenceCount * 4);
    }

    upgrade(Muscular_Augments) && upgrade(Grooved_Spines);
    if (enemyStaticDefenceCount == 0 && !enemyHasExpanded) {
      buildN(Zerg_Hydralisk, 12);
      buildSunkens(st, 3);
    }
    buildN(Zerg_Hydralisk, 2);
    buildN(Zerg_Drone, 18);

    buildN(Zerg_Hydralisk_Den, 1);
    buildN(Zerg_Drone, 16);

    buildN(Zerg_Hatchery, 3);
    buildN(Zerg_Drone, 14);
    if (st.frame < 15 * 60 * 11) {
      if (enemyZealotCount / 2.0 - armySupply / 2.0 >
          countPlusProduction(st, Zerg_Sunken_Colony) - 1) {
        buildSunkens(st, 4);
      }
    }
    buildN(Zerg_Zergling, 4);
    buildSunkens(st, (enemyZealotCount ? 2 : 1) + hurtSunkens);
    buildN(Zerg_Overlord, 2);
    buildN(Zerg_Spawning_Pool, 1);
    if (countPlusProduction(st, Zerg_Hatchery) == 1) {
      build(Zerg_Hatchery, nextBase);
      if (!hasBuiltExtractor && buildExtractor) {
        buildN(Zerg_Extractor, 1);
      }
      buildN(Zerg_Drone, 9);
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBOzvp10hatch>("ABBOzvp10hatch")(
      metadata("type", rttr::type::get<ABBOzvp10hatch>()))
      .constructor<UpcId>();
}
}
