/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"
#include "registry.h"

namespace fairrsh {

class ABBOximptest : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  bool buildExtractor = false;
  bool hasBuiltExtractor = false;

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    build(Zerg_Hydralisk);

    buildN(Zerg_Drone, 70);

    buildN(Zerg_Hydralisk, 30);

    upgrade(Grooved_Spines) && upgrade(Muscular_Augments);

    buildN(Zerg_Drone, 40);
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBOximptest>("ABBOximptest")(
      metadata("type", rttr::type::get<ABBOximptest>()))
      .constructor<UpcId>();
}
}
