/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "registry.h"
#include "base.h"
#include "utils.h"

namespace fairrsh {

namespace buildorders {

std::shared_ptr<AutoBuildTask> createTask(UpcId srcUpcId, std::string name) {
  auto lowerName = utils::stringToLower(name);

  for (auto typ : rttr::type::get<ABBOBase>().get_derived_classes()) {
    auto lowerType = utils::stringToLower(typ.get_name());
    if (lowerType == lowerName || lowerType == "abbo" + lowerName) {
      auto var =
          typ.get_constructor({rttr::type::get<UpcId>()}).invoke(srcUpcId);
      if (!var.is_valid()) {
        LOG(DFATAL) << "failed to instantiate build order: " << name;
      } else {
        LOG(WARNING) << "Instantiated build order: " << name;
      }
      return var.get_value<std::shared_ptr<AutoBuildTask>>();
    }
  }

  LOG(DFATAL) << "no such build order: " << name;
}
}
}
