/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBOMeanLingRush : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    state->board()->post("kMinScoutFrame", 0);

    auto st = autobuild::getMyState(state);
    bool gorush = false;
    for (Unit* u : state->unitsInfo().enemyUnits()) {
      if (!u->gone && u->type->isBuilding && !u->flying()) {
        gorush = true;
      }
      if (u->type->gasCost && !u->type->isBuilding) {
        if (u->flying() || enemyRace != +tc::BW::Race::Terran) {
          gorush = false;
          break;
        }
      }
    }
    if (state->currentFrame() >= 15 * 60 * 20 ||
        !state->unitsInfo().myUnitsOfType(Zerg_Mutalisk).empty()) {
      gorush = false;
    }
    if (enemyStaticDefenceCount || enemyZealotCount || enemyMarineCount >= armySupply / 2.0) {
      gorush = false;
    }
    state->board()->post("MeanLingRushEnabled", gorush);

    if (hasOrInProduction(st, Metabolic_Boost) || st.gas >= 100.0) {
      state->board()->post("GathererMinGasGatherers", 0);
      state->board()->post("GathererMaxGasGatherers", 0);
    } else {
      state->board()->post("GathererMinGasGatherers", 3);
      state->board()->post("GathererMaxGasGatherers", 3);
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    if (countPlusProduction(st, Zerg_Zergling) < 100) {
      build(Zerg_Zergling);
      upgrade(Metabolic_Boost);
    }

    if (countPlusProduction(st, Zerg_Zergling) >= 60) {
      build(Zerg_Mutalisk);
      buildN(Zerg_Spire, 1);
      buildN(Zerg_Lair, 1);
      buildN(Zerg_Drone, 50);
    }

    buildN(Zerg_Drone, 9);
    buildN(Zerg_Extractor, 1);
    buildN(Zerg_Spawning_Pool, 1);
    if (countPlusProduction(st, Zerg_Hatchery) == 1) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 9);
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBOMeanLingRush>("ABBOMeanLingRush")(
      metadata("type", rttr::type::get<ABBOMeanLingRush>()))
      .constructor<UpcId>();
}
}
