/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBOHydras : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    st.autoBuildRefineries = countPlusProduction(st, Zerg_Extractor) == 0;

    build(Zerg_Hydralisk);
    upgrade(Grooved_Spines) && upgrade(Muscular_Augments);
    buildN(Zerg_Hatchery, 4);
    buildN(Zerg_Drone, 30);

    buildN(Zerg_Hydralisk, 4);
    buildN(Zerg_Drone, 16);

    if (st.frame < 15 * 60 * 9) {

      if (myCompletedHatchCount >= 2) {
        if (hasOrInProduction(st, Zerg_Creep_Colony)) {
          build(Zerg_Sunken_Colony);
        } else {
          if (countPlusProduction(st, Zerg_Sunken_Colony) < 1) {
            build(Zerg_Creep_Colony, nextStaticDefencePos);
          }
        }
      }
      buildN(Zerg_Hatchery, 3);
      buildN(Zerg_Spawning_Pool, 1);
      if (countPlusProduction(st, Zerg_Hatchery) == 1) {
        build(Zerg_Hatchery, nextBase);
        buildN(Zerg_Drone, 12);
      }
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBOHydras>("ABBOHydras")(
      metadata("type", rttr::type::get<ABBOHydras>()))
      .constructor<UpcId>();
}
}
