/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "../modules/autobuild.h"

#include "../modules/builderhelper.h"
#include "utils.h"

namespace fairrsh {

class ABBOBase : public AutoBuildTask {
 public:
  ABBOBase(int upcId) : AutoBuildTask(upcId) {}

  Position nextBase;
  bool canExpand = false;
  bool shouldExpand = false;
  bool forceExpand = false;

  int enemyZealotCount = 0;
  int enemyVultureCount = 0;
  int enemyGoliathCount = 0;
  int enemyTankCount = 0;
  int enemyMissileTurretCount = 0;
  int enemyCorsairCount = 0;
  int enemyWraithCount = 0;
  int enemyStaticDefenceCount = 0;
  int enemyReaverCount = 0;
  int enemyBarracksCount = 0;
  int enemyMutaliskCount = 0;
  int enemyMarineCount = 0;
  int enemyFactoryCount = 0;
  bool enemyHasExpanded = false;
  bool enemyIsRushing = false; // TODO detect for protoss / zerg

  int myCompletedHatchCount = 0;
  int myZerglingCount = 0;

  Position homePosition;
  Position naturalPos;
  Position naturalDefencePos;
  Position enemyBasePos;
  bool hasFoundEnemyBase = false;
  Position nextStaticDefencePos;
  bool weArePlanningExpansion = false;
  int currentFrame = 0;

  int bases = 0;

  bool isLosingAnOverlord = false;

  Position lastFindNaturalDefencePosEnemyPos{-1, -1};

  std::vector<uint8_t> inBaseArea =
      std::vector<uint8_t>(TilesInfo::tilesWidth * TilesInfo::tilesHeight);
  FrameNum lastUpdateInBaseArea = 0;

  double armySupply = 0.0;
  double groundArmySupply = 0.0;
  double airArmySupply = 0.0;

  double enemySupplyInOurBase = 0.0;
  double enemyArmySupplyInOurBase = 0.0;
  double enemyArmySupply = 0.0;
  double enemyGroundArmySupply = 0.0;
  double enemyAirArmySupply = 0.0;
  double enemyAntiAirArmySupply = 0.0;
  double enemyAttackingArmySupply = 0.0;
  int enemyAttackingWorkerCount = 0;
  double enemyLargeArmySupply = 0.0;
  double enemySmallArmySupply = 0.0;

  tc::BW::Race enemyRace = tc::BW::Race::Unknown;

  bool autoBuildHatcheries = true;
  bool autoExpand = true;
  bool autoExpandWithMacroHatcheries = false;
  bool expandNearest = false;
  bool buildExtraOverlordsIfLosingThem = true;

  void findNaturalDefencePos(State* state);

  Position getStaticDefencePos(State* state, const BuildType* type);

  void buildSunkens(autobuild::BuildState& st, int n);

  void calculateArmySupply(const autobuild::BuildState& st);

  Position findSunkenPos(State* state, const BuildType* type, bool mainBaseOnly = false, bool coverMineralsOnly = false);

  virtual void preBuild2(State* state, Module* module) {}

  virtual void preBuild(State* state, Module* module) override final;

  virtual void postBuild2(State* state) {}

  virtual void postBuild(State* state) override final;

  virtual void buildStep2(autobuild::BuildState& st) {}

  virtual void buildStep(autobuild::BuildState& st) override final;
};
}
