/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"
#include "registry.h"

namespace fairrsh {

class ABBO9PoolSpeedLingMuta : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  Position nextSunkenPos;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    state->board()->post("kMinScoutFrame", 0);

    bool attack = armySupply >= enemyArmySupply ||
        !state->unitsInfo().myUnitsOfType(Zerg_Mutalisk).empty();
    state->board()->post("TacticsAttack", attack);

    nextSunkenPos = findSunkenPos(state, Zerg_Sunken_Colony);

    utils::drawCircle(state, nextSunkenPos, 32, tc::BW::Color::Red);

    auto st = autobuild::getMyState(state);
    if (countPlusProduction(st, Zerg_Drone) >= 9 && st.gas < 400.0 &&
        (hasOrInProduction(st, Zerg_Lair) || st.gas < 100.0)) {
      if (hasOrInProduction(st, Zerg_Lair)) {
        state->board()->post("GathererMinGasGatherers", 2);
        state->board()->post("GathererMaxGasGatherers", 2);
      } else {
        state->board()->post("GathererMinGasGatherers", 3);
        state->board()->post("GathererMaxGasGatherers", 3);
      }
    } else {
      state->board()->post("GathererMinGasGatherers", 0);
      state->board()->post("GathererMaxGasGatherers", 0);
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    autoBuildHatcheries = hasOrInProduction(st, Zerg_Spire);

    if (hasOrInProduction(st, Zerg_Creep_Colony)) {
      build(Zerg_Sunken_Colony);
      return;
    }

    auto placeSunkens = [&](int n) {
      if (countPlusProduction(st, Zerg_Sunken_Colony) < n) {
        build(Zerg_Creep_Colony, nextSunkenPos);
      }
    };

    if (countPlusProduction(st, Zerg_Sunken_Colony) &&
        enemyArmySupply * 0.75 > armySupply) {
      placeSunkens(4);
      build(Zerg_Zergling);
      buildN(Zerg_Drone, 14);
      placeSunkens(3);
    } else {
      placeSunkens(2);
      build(Zerg_Zergling);
    }
    if (st.gas >= 150.0) {
      build(Metabolic_Boost);
      buildN(Zerg_Lair, 1);
    }
    if (has(st, Zerg_Lair)) {
      build(Zerg_Mutalisk);
    }
    if (enemyArmySupply >
        armySupply + countPlusProduction(st, Zerg_Sunken_Colony) * 3) {
      placeSunkens(4);
    }
    if (armySupply >= enemyArmySupply ||
        countPlusProduction(st, Zerg_Sunken_Colony)) {
      buildN(Zerg_Drone, 11);
    }
    if (st.frame < 15 * 60 * 4) {
      buildN(Zerg_Zergling, 6);
    }
    buildN(Zerg_Extractor, 1);
    if (countPlusProduction(st, Zerg_Spawning_Pool) == 0) {
      build(Zerg_Spawning_Pool);
      buildN(Zerg_Drone, 9);
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO9PoolSpeedLingMuta>("ABBO9PoolSpeedLingMuta")(
      metadata("type", rttr::type::get<ABBO9PoolSpeedLingMuta>()))
      .constructor<UpcId>();
}
} // namespace fairrsh
