/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO5Pool : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;
    auto st = getMyState(state);
    state->board()->post("kMinScoutFrame", 0);
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    autoBuildHatcheries = false;

    build(Zerg_Zergling);

    buildN(Zerg_Spawning_Pool, 1);
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO5Pool>("ABBO5Pool")(
      metadata("type", rttr::type::get<ABBO5Pool>()))
      .constructor<UpcId>();
}
}
