/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO3BasePoolLings : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  bool hasSunken = false;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    hasSunken = !state->unitsInfo().myUnitsOfType(Zerg_Sunken_Colony).empty();

    bool attack = true;
    if (state->currentFrame() < 22 * 60 * 9 && enemyVultureCount &&
        (enemyAttackingArmySupply == 0.0 || enemyAttackingArmySupply <= 4.0)) {
      attack = false;
    }
    state->board()->post("TacticsAttack", attack);
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    if (enemyIsRushing && armySupply < enemyAttackingArmySupply + 1.0 &&
        (enemyAttackingArmySupply ||
         (!enemyHasExpanded && enemyStaticDefenceCount == 0))) {
      if (myCompletedHatchCount >= 2 && nextStaticDefencePos != Position()) {
        if (!hasSunken) {
          buildSunkens(st, 2);
        }
      }
      // this flag helps prioritize the hatchery
      auto buildingDefenses = false;
      if (countPlusProduction(st, Zerg_Zergling) <
          std::max(enemyArmySupply * 3, 8.)) {
        build(Zerg_Zergling);
        buildingDefenses = true;
      }
      if (countPlusProduction(st, Zerg_Hatchery) == 1) {
        build(Zerg_Hatchery, nextBase);
      }
      if (buildingDefenses) {
        return;
      }
    }

    if (bases < 6 && armySupply > enemyAttackingArmySupply * 2 &&
        st.minerals < 500 && !st.isExpanding) {
      if (countPlusProduction(st, Zerg_Hatchery) < 8) {
        build(Zerg_Hatchery, nextBase);
      }
    }

    st.autoBuildHatcheries = countPlusProduction(st, Zerg_Hatchery) >= 3;
    st.autoBuildRefineries =
        st.workers >= 50 || countUnits(st, Zerg_Extractor) >= 2;
    build(Zerg_Zergling);

    buildN(Zerg_Drone, 70);

    buildN(Zerg_Scourge, (int)enemyAirArmySupply);
    buildN(Zerg_Spire, 1);

    buildN(Zerg_Zergling, 60);
    buildN(Zerg_Drone, 40);

    if (countUnits(st, Zerg_Drone) > 30 && countUnits(st, Zerg_Zergling) > 16) {
      upgrade(Zerg_Carapace_2) && upgrade(Zerg_Melee_Attacks_2) &&
          upgrade(Zerg_Carapace_3) && upgrade(Zerg_Melee_Attacks_3);
    }

    if (countPlusProduction(st, Zerg_Hatchery) == 3 && !st.isExpanding) {
      build(Zerg_Hatchery, nextBase);
    }

    upgrade(Zerg_Carapace_1) && upgrade(Zerg_Melee_Attacks_1);
    buildN(Zerg_Drone, 26);

    if (st.workers < 40 && armySupply < enemyAttackingArmySupply) {
      build(Zerg_Zergling);
    }

    if (st.workers >= 42) {
      upgrade(Adrenal_Glands);
    }
    upgrade(Metabolic_Boost);
    buildN(Zerg_Extractor, 1);
    buildN(Zerg_Drone, 20);

    buildN(Zerg_Spawning_Pool, 1);
    if (countPlusProduction(st, Zerg_Hatchery) == 2) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 14);
    }
    if (countPlusProduction(st, Zerg_Hatchery) == 1) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 12);
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO3BasePoolLings>("ABBO3BasePoolLings")(
      metadata("type", rttr::type::get<ABBO3BasePoolLings>()))
      .constructor<UpcId>();
}
}
