/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO3BasePool : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    if (bases >= 3 &&
        !state->unitsInfo().myUnitsOfType(Zerg_Spawning_Pool).empty()) {
      setStatus(TaskStatus::Success);
    } else if (
        state->unitsInfo().myWorkers().size() >= 20 ||
        enemyArmySupplyInOurBase) {
      setStatus(TaskStatus::Failure);
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    autoBuildHatcheries = false;

    buildN(Zerg_Drone, 20);

    buildN(Zerg_Spawning_Pool, 1);
    if (countPlusProduction(st, Zerg_Hatchery) == 2) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 14);
    }
    if (countPlusProduction(st, Zerg_Hatchery) == 1) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 12);
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO3BasePool>("ABBO3BasePool")(
      metadata("type", rttr::type::get<ABBO3BasePool>()))
      .constructor<UpcId>();
}
}
