/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO2HatchMuta : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  bool saveLarva = false;
  Position nextSunkenPos;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    auto st = getMyState(state);
    bool attack = false;
    if (st.frame < 24 * 60 * 9) {
      if (armySupply > enemyAttackingArmySupply) {
        attack = true;
      }
    } else {
      if (enemyAttackingArmySupply >= enemyArmySupply * 0.5) {
        attack = true;
      }
      if (armySupply >= 40.0) {
        attack = true;
      }
    }
    if (weArePlanningExpansion) {
      attack = true;
    }
    state->board()->post("TacticsAttack", attack);

    saveLarva = false;
    if (state->unitsInfo().myCompletedUnitsOfType(Zerg_Spire).empty()) {
      for (Unit* u : state->unitsInfo().myUnitsOfType(Zerg_Spire)) {
        if (u->remainingBuildTrainTime < 900) {
          saveLarva = true;
        }
      }
    }

    nextSunkenPos = findSunkenPos(state, Zerg_Sunken_Colony, true, true);

    if (state->currentFrame() >= 24 * 60 * 8) {
      state->board()->remove("GathererMinGasGatherers");
      state->board()->remove("GathererMaxGasGatherers");
    } else {
      double desiredGas = 0.0;
      if (!hasOrInProduction(st, Zerg_Lair)) desiredGas = 100.0;
      else if (!hasOrInProduction(st, Zerg_Spire)) desiredGas = 200.0;
      else desiredGas = 800.0;
      if (st.gas < desiredGas) {
        state->board()->post("GathererMinGasGatherers", 9);
        state->board()->post("GathererMaxGasGatherers", 9);
      } else {
        state->board()->post("GathererMinGasGatherers", 0);
        state->board()->post("GathererMaxGasGatherers", 0);
      }
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    if (st.frame < 24 * 60 * 8) {
      st.autoBuildRefineries = false;
      autoBuildHatcheries = false;
      autoExpand = false;
    } else {
      autoBuildHatcheries = true;
      autoExpand = true;
    }

    if (hasOrInProduction(st, Zerg_Creep_Colony)) {
      build(Zerg_Sunken_Colony);
      return;
    }

    auto placeSunkens = [&](int n) {
      if (countPlusProduction(st, Zerg_Sunken_Colony) < n) {
        build(Zerg_Creep_Colony, nextSunkenPos);
      }
    };

    if (saveLarva) {
      buildN(Zerg_Hatchery, 3);
      buildN(Zerg_Overlord, 5);
      return;
    }

    if (st.frame < 24 * 60 * 8) {
      build(Zerg_Zergling);
      if (enemyArmySupply + enemyVultureCount < 12.0) {
        buildN(Zerg_Drone, 26);
      } else {
        buildN(Zerg_Drone, 19);
      }
      build(Zerg_Mutalisk);
    } else {
      build(Zerg_Zergling);
      if (countPlusProduction(st, Zerg_Mutalisk) < 6 || enemyAntiAirArmySupply < enemyArmySupply * 0.4 || countPlusProduction(st, Zerg_Mutalisk) < countPlusProduction(st, Zerg_Zergling) / 10) {
        build(Zerg_Mutalisk);
      }
      if (countPlusProduction(st, Zerg_Scourge) < enemyAirArmySupply) {
        build(Zerg_Scourge);
      }
//      if (bases >= 3 && (st.frame >= 24 * 60 * 15 || armySupply >= 32.0)) {
//        if (enemyLargeArmySupply >= enemyArmySupply * 0.5 || enemyAntiAirArmySupply >= enemyArmySupply * 0.4) {
//          if (has(st, Grooved_Spines)) {
//            buildN(Zerg_Hydralisk, (int)enemyLargeArmySupply - enemyTankCount + enemyVultureCount);
//          }
//          upgrade(Grooved_Spines) && upgrade(Muscular_Augments);
//          if (st.workers >= 49 && enemyAirArmySupply < enemyArmySupply * 0.5) {
//            if (armySupply > enemyArmySupply) {
//              upgrade(Lurker_Aspect);
//            }
//            if (has(st, Lurker_Aspect)) {
//              buildN(Zerg_Lurker, (int)((armySupply - enemyAirArmySupply) / 12.0));
//            }
//          }
//        }
//      }
      if (armySupply > enemyArmySupply * 0.66) {
        if (countProduction(st, Zerg_Drone) < (armySupply > enemyArmySupply ? 2 : 1)) {
          buildN(Zerg_Drone, 66);
        }
      }
      if (countPlusProduction(st, Zerg_Mutalisk) >= 6 || armySupply >= 20.0) {
        if (armySupply > enemyArmySupply) {
          buildN(Zerg_Drone, 32);
        }
      }
      if (bases >= 3) {
        upgrade(Zerg_Carapace_1) && upgrade(Zerg_Melee_Attacks_1) &&
            upgrade(Zerg_Carapace_2) && upgrade(Zerg_Melee_Attacks_2) &&
            upgrade(Zerg_Carapace_3) && upgrade(Zerg_Melee_Attacks_3);
        upgrade(Adrenal_Glands);
        if (st.workers >= 46) {
          buildN(Zerg_Evolution_Chamber, 2);
        }
      }

      if (armySupply >= 16.0 && armySupply >= enemyAttackingArmySupply + 8.0 && st.workers >= 24) {
        if (bases < 4 && canExpand && !st.isExpanding) {
          build(Zerg_Hatchery, nextBase);
        }
      }
    }
    if (hasOrInProduction(st, Zerg_Spire)) {
      buildN(Zerg_Extractor, 2);
      upgrade(Zerg_Melee_Attacks_1);
    }
    if (!has(st, Zerg_Spire)) {
      buildN(Zerg_Spire, 1);
      buildN(Zerg_Drone, 20);
      upgrade(Metabolic_Boost);
      buildN(Zerg_Lair, 1);
      buildN(Zerg_Drone, 12);
      buildN(Zerg_Zergling, 2);
    }

    if (enemyVultureCount && countPlusProduction(st, Zerg_Sunken_Colony)) {
      placeSunkens(2);
    }

    if (enemyArmySupplyInOurBase) {
      buildN(Zerg_Zergling, 4);
    }

    if (myCompletedHatchCount >= 2 &&
        (st.workers >= 12 || enemyArmySupplyInOurBase) &&
        !has(st, Zerg_Spire)) {
      buildSunkens(st, 1);
//      if (hasOrInProduction(st, Zerg_Creep_Colony)) {
//        build(Zerg_Sunken_Colony);
//      } else {
//        int droneCount = countPlusProduction(st, Zerg_Drone);
//        int desiredSunkenCount = 0;
//        if (droneCount >= 16) {
//          desiredSunkenCount = 1;
//        }
////        if (enemyArmySupply - enemyVultureCount >= 4.0)
////          desiredSunkenCount = 2;
////        if (enemyArmySupply - enemyVultureCount >= 10.0)
////          desiredSunkenCount = 4;
//        if (countPlusProduction(st, Zerg_Sunken_Colony) < desiredSunkenCount &&
//            !isInProduction(st, Zerg_Creep_Colony)) {
//          build(Zerg_Creep_Colony, nextStaticDefencePos);
//        }
//      }
    }
    buildN(Zerg_Extractor, 1);
    buildN(Zerg_Spawning_Pool, 1);
    if (countPlusProduction(st, Zerg_Hatchery) == 1) {
      build(Zerg_Hatchery, nextBase);
      buildN(Zerg_Drone, 12);
    }

//    if (st.workers >= 13 && armySupply < enemySupplyInOurBase + 1.0) {
//      build(Zerg_Zergling);
//    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO2HatchMuta>("ABBO2HatchMuta")(
      metadata("type", rttr::type::get<ABBO2HatchMuta>()))
      .constructor<UpcId>();
}
}
