/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO1HatchLurker : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    state->board()->post("kMinScoutFrame", 0);

    bool gorush = false;
    for (Unit* u : state->unitsInfo().enemyUnits()) {
      if (!u->gone && u->type->isBuilding && !u->flying()) {
        gorush = true;
      }
    }
    if (state->currentFrame() >= 15 * 60 * 20 ||
        !state->unitsInfo().myUnitsOfType(Zerg_Mutalisk).empty()) {
      gorush = false;
    }
    state->board()->post("MeanLingRushEnabled", gorush);

    auto st = autobuild::getMyState(state);
    if (state->unitsInfo().myWorkers().size() >= 9 &&
        countPlusProduction(st, Zerg_Lurker) < 4) {
      state->board()->post("GathererMinGasGatherers", 3);
      state->board()->post("GathererMaxGasGatherers", 3);
    } else {
      state->board()->post("GathererMinGasGatherers", 0);
      state->board()->post("GathererMaxGasGatherers", 0);
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    st.autoBuildRefineries = countPlusProduction(st, Zerg_Extractor) == 0 ||
        st.frame >= 15 * 60 * 11;

    if (st.usedSupply[tc::BW::Race::Zerg] < 170.0) {
      build(Zerg_Zergling);
      if (countPlusProduction(st, Zerg_Lurker) < 4) {
        buildN(
            Zerg_Hydralisk,
            4 - countPlusProduction(st, Zerg_Lurker) -
                countPlusProduction(st, Zerg_Hydralisk));
        build(Zerg_Lurker);
      }
      if (armySupply >= 40.0) {
        buildN(Zerg_Hydralisk, 8);
      }
    }

    if (armySupply >= 75.0) {
      build(Zerg_Mutalisk);
      buildN(Zerg_Drone, 50);
    }

    buildN(Zerg_Zergling, 8);
    upgrade(Lurker_Aspect);
    upgrade(Metabolic_Boost);
    buildN(Zerg_Lair, 1);

    buildN(Zerg_Zergling, 2);
    buildN(Zerg_Drone, 10);

    buildN(Zerg_Extractor, 1);
    buildN(Zerg_Spawning_Pool, 1);
    buildN(Zerg_Drone, 9);
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO1HatchLurker>("ABBO1HatchLurker")(
      metadata("type", rttr::type::get<ABBO1HatchLurker>()))
      .constructor<UpcId>();
}
}
