/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "base.h"

namespace fairrsh {

class ABBO12PoolMuta : public ABBOBase {
  RTTR_ENABLE(ABBOBase)
 public:
  using ABBOBase::ABBOBase;

  bool hasSpire = false;
  bool hasCompletedSpire = false;
  bool hasMutas = false;

  virtual void preBuild2(State* state, Module* module) override {
    using namespace buildtypes;
    using namespace autobuild;

    auto st = getMyState(state);
    bool attack = st.frame >= 15 * 60 * 8;
    state->board()->post("TacticsAttack", attack);

    hasSpire = !state->unitsInfo().myUnitsOfType(Zerg_Spire).empty();
    hasCompletedSpire =
        !state->unitsInfo().myCompletedUnitsOfType(Zerg_Spire).empty();
    hasMutas = !state->unitsInfo().myUnitsOfType(Zerg_Mutalisk).empty();

    if (state->currentFrame() >= 15 * 60 * 10) {
      state->board()->remove("GathererMinGasGatherers");
      state->board()->remove("GathererMaxGasGatherers");
    } else {
      double desiredGas = 0.0;
      if (!hasOrInProduction(st, Zerg_Lair))
        desiredGas = 100.0;
      else
        desiredGas = 600.0;
      if (countPlusProduction(st, Zerg_Sunken_Colony) < 2 && hasSpire) {
        desiredGas = 0.0;
      }
      if (st.gas < desiredGas) {
        state->board()->post("GathererMinGasGatherers", 90);
        state->board()->post("GathererMaxGasGatherers", 90);
      } else {
        state->board()->post("GathererMinGasGatherers", 0);
        state->board()->post("GathererMaxGasGatherers", 0);
      }
    }
  }

  virtual void buildStep2(autobuild::BuildState& st) override {
    using namespace buildtypes;
    using namespace autobuild;

    st.autoBuildRefineries = countPlusProduction(st, Zerg_Extractor) == 0 ||
        currentFrame >= 15 * 60 * 8 || hasCompletedSpire;
    autoBuildHatcheries = currentFrame >= 15 * 60 * 9;
    autoExpand = autoBuildHatcheries;

    if (st.frame < 15 * 60 * 12 && !hasSpire) {
      buildN(Zerg_Drone, 18);
      buildN(Zerg_Spire, 1);
      buildSunkens(st, 1);
      if (enemySupplyInOurBase) {
        buildN(Zerg_Zergling, (int)(enemyAttackingArmySupply * 0.875));
      }
      buildN(Zerg_Overlord, 2);
      buildN(Zerg_Drone, 14);
      buildN(Zerg_Zergling, 4);
      buildN(Zerg_Lair, 1);

      if (countPlusProduction(st, Zerg_Hatchery) == 1) {
        build(Zerg_Hatchery, nextBase);
      }
      buildN(Zerg_Extractor, 1);
      buildN(Zerg_Spawning_Pool, 1);
      if (enemyArmySupplyInOurBase == 0.0 &&
          countPlusProduction(st, Zerg_Sunken_Colony) == 0) {
        buildN(Zerg_Drone, 13);
      } else {
        buildN(Zerg_Zergling, 6);
      }
      return;
    }

    int droneCount = countPlusProduction(st, Zerg_Drone);
    int zerglingCount = countPlusProduction(st, Zerg_Zergling);
    int mutaliskCount = countPlusProduction(st, Zerg_Mutalisk);
    int scourgeCount = countPlusProduction(st, Zerg_Scourge);

    if (countPlusProduction(st, Zerg_Hatchery) >= 3 && hasMutas) {
      if (bases < 3 && canExpand && !st.isExpanding) {
        build(Zerg_Hatchery, nextBase);
      }
    }

    if (st.frame >= 15 * 60 * 6 &&
        (droneCount >= 24 ||
         (armySupply < enemySupplyInOurBase -
              countPlusProduction(st, Zerg_Sunken_Colony) * 3) ||
         hasSpire)) {
      build(Zerg_Zergling);
      build(Zerg_Mutalisk);

      if (st.frame >= 15 * 60 * 9) {
        if (mutaliskCount >= 9 || zerglingCount >= 12) {
          upgrade(Metabolic_Boost);
        }

        if (zerglingCount < enemyMissileTurretCount * 3 -
                enemyVultureCount * 4 + enemyGoliathCount * 2) {
          buildN(Zerg_Zergling, mutaliskCount * 3);
        }

        if (mutaliskCount >= 24) {
          buildN(Zerg_Zergling, mutaliskCount);
        }
      }

      if (scourgeCount < enemyAirArmySupply) {
        build(Zerg_Scourge);
      }
    } else {
      buildN(Zerg_Drone, 30);
    }

    if (st.frame >= 15 * 60 * 7 + 15 * 30 && !enemyHasExpanded &&
        enemyFactoryCount == 0 && mutaliskCount == 0) {
      buildSunkens(st, 3);
      if (enemyAttackingArmySupply - enemyVultureCount * 2 >= 4.0) {
        buildSunkens(st, 4);
      }
    }
    if (droneCount < 22 && !hasSpire) {
      if (droneCount >= 16 && enemyMarineCount >= 8) {
        buildSunkens(st, std::max((int)(enemyArmySupply / 2.5), 5));
      }
    }

    if (mutaliskCount >= 10) {
      upgrade(Zerg_Flyer_Carapace_1) && upgrade(Zerg_Flyer_Attacks_1) &&
          upgrade(Zerg_Flyer_Carapace_2) && upgrade(Zerg_Flyer_Attacks_2);
      if (mutaliskCount >= 20) {
        upgrade(Zerg_Melee_Attacks_1) && upgrade(Zerg_Carapace_1);
      }
    }

    if (!enemyHasExpanded) {
      if (enemyStaticDefenceCount) {
        buildSunkens(st, 1);
      } else {
        buildSunkens(st, 2);
      }
    }

    if (enemySupplyInOurBase && !hasCompletedSpire) {
      buildN(Zerg_Zergling, (int)(enemyAttackingArmySupply * 0.875));
    }

    if ((std::max(enemyArmySupply - 6.0, enemyAttackingArmySupply) >= 4.0 &&
         armySupply < 8.0) ||
        enemyVultureCount) {
      buildSunkens(st, 2);
    }

    if (st.frame >= 15 * 60 * 15) {
      // if (countProduction(st, Zerg_Drone) == 0 && totalDronesMade < 6 +
      // st.frame / 15 * 30) {
      if (countProduction(st, Zerg_Drone) == 0 &&
          droneCount < 12 + st.frame / 15 * 30) {
        buildN(Zerg_Drone, 48);
      }

      if (droneCount >= 29) {
        if (upgrade(Pneumatized_Carapace) && has(st, Pneumatized_Carapace)) {
          if (bases >= 3) {
            buildN(Zerg_Hive, 1) && upgrade(Adrenal_Glands);
          }
        }
      }
    }

    if (armySupply > enemyArmySupply || armySupply >= 6.0) {
      buildN(Zerg_Drone, 20);
    }
    if (mutaliskCount >= 11 &&
        mutaliskCount * 2 >= std::max(7, (int)(enemyArmySupply / 2.0))) {
      buildN(Zerg_Drone, 32);
    }

    if (countPlusProduction(st, Zerg_Creep_Colony)) {
      build(Zerg_Sunken_Colony);
    }

    if (st.frame < 15 * 60 * 11) {
      bool makeLings = zerglingCount < enemyZealotCount * 3;
      if (enemyRace == +tc::BW::Race::Protoss || enemyZealotCount) {
        if (droneCount >= 14 && zerglingCount < 8) {
          makeLings = true;
        }
      }
      if (makeLings) {
        upgrade(Metabolic_Boost);
        buildSunkens(st, enemyArmySupply >= 6.0 ? 3 : 2);
        build(Zerg_Zergling);
      }
    }
  }
};

RTTR_REGISTRATION {
  rttr::registration::class_<ABBO12PoolMuta>("ABBO12PoolMuta")(
      metadata("type", rttr::type::get<ABBO12PoolMuta>()))
      .constructor<UpcId>();
}
}
