# MegaBot
StarCraft bot designed to test strategy selection. For MegaBot, strategy is the incorporation of another bot's behavior. Currently it incorporates Skynet, Xelnaga and NUSBot.

- For a detailed description of MegaBot, check out the wiki: https://github.com/andertavares/MegaBot/wiki

# Running MegaBot
- Copy MegaBot.dll and megabot_config.xml into bwapi-data/AI
- Make sure that the directories bwapi-data/read and bwapi-data/write exist
- Configure your bwapi.ini properly and enjoy :)

# Build requirements and instructions
(from https://github.com/andertavares/MegaBot/wiki/Build-instructions)

## Requirements
Pre-requisites:
- Windows 7 (these instructions were tested on Win7 64 bits - but might work on posterior versions. Won't work on WinXP because VS2012 cannot be installed there)
- StarCraft patched to 1.16.1

For the items below, install and configuration instructions are given on this page:
- BWAPI 3.7.4 
- Visual C++2008 with SP 1 
- Visual C++2010 
- Visual Studio 2012 
- Boost 1.60.0 

## Instructions
### BWAPI 
- Get `BWAPI.3.7.4.7z` file from: https://github.com/bwapi/bwapi/releases/tag/v3.7.4
- (if you don't have 7zip to unpack .7z files, grab it here: http://www.7-zip.org/)
- Extract the contents of `BWAPI.3.7.4.7z` to `c:\software\BWAPI3.7.4`. Note that you cannot have empty spaces on path.
- Open a console with admin privileges, go to `c:\software\BWAPI3.7.4` and type `install.exe`. The setup will ask you for the location of Starcraft.exe and copy appropriated files there.
- If you get no errors, your BWAPI setup is finished and you can skip the remainder of this section
- If you get errors, you'll have to go the python way:
- Install a python distribution (I recommend Enthought Canopy: https://store.enthought.com/downloads/ because it already comes with easy_install)
- Open a console with admin privileges and type `easy_install winshell`
- Go to `c:\software\BWAPI3.7.4` and type `python install.py`. The setup will ask you for the location of Starcraft.exe and copy appropriated files there.

### Visual Studio(s)
- Install Visual C++ 2008 with Service Pack 1 (dowload link: http://download.microsoft.com/download/E/8/E/E8EEB394-7F42-4963-A2D8-29559B738298/VS2008ExpressWithSP1ENUX1504728.iso). Code won't build without Service Pack 1.
- Install Visual C++2010 (download link: http://download.microsoft.com/download/1/D/9/1D9A6C0E-FC89-43EE-9658-B9F0E3A76983/vc_web.exe)
- Install Visual Studio 2012 (download link: https://www.microsoft.com/en-us/download/details.aspx?id=34673)

All three versions of Visual Studio are required. In section "Compiling" you'll see that you need to open the project with VS2012, but use VC++2008 toolset to compile. VC++2010 is what allows VS2012 to use 2008's toolset. This is needed because code does not compile with VS 2012 toolset and does not link in VC++2008 nor VC++2010.

### Boost
- Download `boost_1_60_0-msvc-9.0-32.exe` from https://sourceforge.net/projects/boost/files/boost-binaries/1.60.0/boost_1_60_0-msvc-9.0-32.exe/download . This link goes directly to 32 bit, VC++2008 compatible version of Boost and should work. If, for some reason, you need another version, look into: https://sourceforge.net/projects/boost/files/boost-binaries/1.60.0/
- Install Boost 1.60.0 to `c:\software\boost` (note that path has no spaces)
- Rename directory `c:\software\boost_1_60_0\lib32-msvc-9.0` to `C:\software\boost_1_60_0\lib`

### Environment Variables
You must configure 2 environment variables:
- `BWAPI_DIR` pointing to where you unpacked BWAPI (if you followed these instructions it will be: `c:\software\BWAPI3.7.4`
- `BOOST_DIR` pointing to where you installed Boost (if you followed these instructions it will be: `c:\software\boost`

On Windows 7, the procedure is as follows:
- Open Start menu, right click "Computer" then "Properties"
- Click "Advanced system configuration"
- In "Advanced" tab, click "Environment variables"
- In "System variables" click "New"
- Set the name and value as indicated (e.g.: name: `BWAPI_DIR` / value: `c:\software\BWAPI3.7.4`)

### Compiling the code
- Get MegaBot's code
- Go to `MEGABOT_DIR/MegaBot/` and open MegaBot.v11.sln (not MegaBot.sln or MegaBot.v10.sln) in Visual Studio 2012. MEGABOT_DIR is where you cloned or unpacked MegaBot's sources.
- If Visual Studio prompt you about updating project files, select "Don't update"
- Make sure all projects will be built with VC++2008 (v90) toolset
- Set the configuration to 'Release'
- Hit "build" (Menu Build->Build solultion or hit F7) and wait for some (a lot) time and warnings...
- At the end, MegaBot.dll is available at MegaBot/Release.
- The build has finished. Make sure to copy megabot_config.xml together with the dll. 


# Academics
MegaBot is the "child" of an academic work:
Tavares, dos Santos, Azupúrua, Chaimowicz. _Rock, Paper, StarCraft: Strategy Selection in Real-Time Strategy Games_. AIIDE 2016. Link: http://aaai.org/ocs/index.php/AIIDE/AIIDE16/paper/view/13998

# The MegaBot team
- Anderson "Zealot" Tavares
- Amanda "Valkyrie" Santos
- Hector "Firebat" Azpúrua
- Tiago "Goliath" Oliveira
- Luiz "Commander" Chaimowicz
