#pragma once

#include "Common.h"
#include "BuildOrderQueue.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildOrder.h"

namespace UAlbertaBot
{
typedef std::pair<MetaType, size_t> MetaPair;
typedef std::vector<MetaPair> MetaPairVector;

struct Strategy
{
    std::string _name;
    BWAPI::Race _race;
    int         _wins;
    int         _losses;
    BuildOrder  _buildOrder;

    Strategy()
        : _name("None")
        , _race(BWAPI::Races::None)
        , _wins(0)
        , _losses(0)
    {
    
    }

    Strategy(const std::string & name, const BWAPI::Race & race, const BuildOrder & buildOrder)
        : _name(name)
        , _race(race)
        , _wins(0)
        , _losses(0)
        , _buildOrder(buildOrder)
    {
    
    }
};

struct Strat
{
	int AllInWorkerSupply = 150;
	int FreeStyleWorkerSupply = 100;
	int WorkerSupplyBeforeUnits = 22;
	double droneToUnitRatio = 0.6;
	bool AllowDronesInsteadOfLingDuringAllIn = true;
	bool expansionsitic = false;
	bool AllowAllIn = false;
	int TechSpeed = 1; //higher values will make low-tech-units less desirable more quickly
	int ForceToSaveForHatchAt = 0;
	int ForceToSaveForPoolAt = 0;
	bool underSiege = false;
	bool attackWithoutLingSpeed = true;

	bool enableZergling = false;
	bool enableHydralisk = false;
	bool enableLurker = false;
	bool enableMutalisk = false;
	bool enableUltralisk = false;
	bool enableGuardian = false;
	double ZerglingDeflation = 1; //the higher this value the fewer will be built of this
	double HydraliskDeflation = 1;
	double LurkerDeflation = 1;
	double MutaliskDeflation = 1;
	double UltraliskDeflation = 1;
	double GuardianDeflation = 1;
};

class StrategyManager 
{
	StrategyManager();

	BWAPI::Race					    _selfRace;
	BWAPI::Race					    _enemyRace;
    std::map<std::string, Strategy> _strategies;
    int                             _totalGamesPlayed;
    const BuildOrder                _emptyBuildOrder;

	        void	                writeResults();
	const   float                   getUnitScore(BWAPI::UnitType unit) const;
	const	double				    getUCBValue(const size_t & strategy) const;
    const	MetaPairVector		    getProtossBuildOrderGoal() const;
	const	MetaPairVector		    getTerranBuildOrderGoal() const;
	const	MetaPairVector		    getZergBuildOrderGoal() const;

public:
    
	static	StrategyManager &	    Instance();
	const	int					    getScore(BWAPI::Player player) const;

			void				    onEnd(const bool isWinner);
            void                    addStrategy(const std::string & name, Strategy & strategy);
            void                    setLearnedStrategy();
            void	                readResults();
	const	bool				    regroup(int numInRadius);
	const	bool				    rushDetected();
	const	int				        defendWithWorkers();
	const	MetaPairVector		    getBuildOrderGoal();
	const	BuildOrder &            getOpeningBookBuildOrder() const;
	const	bool				    shouldExpandNow() const;
	const	bool					needMacroHatch(int hatchCount, double costOfPreferredUnit) const;
	const	bool					baseUnderAttack(bool ignoreWorkers = true) const;
	Strat							strategy;
};
}