#pragma once

#include "Common.h"
#include "UnitData.h"

namespace UAlbertaBot
{
struct BaseInfo;
typedef std::vector<BaseInfo> BaseInfoVector;

class InformationManager 
{
    InformationManager();
    
    BWAPI::Player       _self;
    BWAPI::Player       _enemy;
	BWAPI::Player       _neutral;

    std::map<BWAPI::Player, UnitData>                   _unitData;

    int                     getIndex(BWAPI::Player player) const;

    void                    updateUnit(BWAPI::Unit unit);
    void                    initializeBaseInfoVector();
    void                    updateUnitInfo();
    bool                    isValidUnit(BWAPI::Unit unit);

public:

    // yay for singletons!
    static InformationManager & Instance();

    void                    update();

    // event driven stuff
    void					onUnitShow(BWAPI::Unit unit)        { updateUnit(unit); }
    void					onUnitHide(BWAPI::Unit unit)        { updateUnit(unit); }
    void					onUnitCreate(BWAPI::Unit unit)		{ updateUnit(unit); }
    void					onUnitComplete(BWAPI::Unit unit)    { updateUnit(unit); }
    void					onUnitMorph(BWAPI::Unit unit)       { updateUnit(unit); }
    void					onUnitRenegade(BWAPI::Unit unit)    { updateUnit(unit); }
    void					onUnitDestroy(BWAPI::Unit unit);

    bool					isEnemyBuildingInRegion(BWEM::Area * region);
    int						getNumUnits(BWAPI::UnitType type,BWAPI::Player player);
    bool					nearbyForceHasCloaked(BWAPI::Position p,BWAPI::Player player,int radius);
    bool					isCombatUnit(BWAPI::UnitType type) const;

    void                    getNearbyForce(std::vector<UnitInfo> & unitInfo,BWAPI::Position p,BWAPI::Player player,int radius, int buildingradius = 0);

    const UIMap &           getUnitInfo(BWAPI::Player player) const;

    std::set<BWEM::Area *> &  getOccupiedRegions(BWAPI::Player player);
    BWAPI::TilePosition     getMainBaseLocation(BWAPI::Player player);

    bool                    enemyHasCloakedUnits();

    void                    drawExtendedInterface();
    void                    drawUnitInformation(int x,int y);
    void                    drawMapInformation();

    const UnitData &        getUnitData(BWAPI::Player player) const;

	double					droneScore;
	double					lingScore;
	double					hydraScore;
	double					lurkerScore;
	double					mutaScore;
	double					ultraScore;
	double					guardScore;

	double					supplyIWasAttacked = 400;
	double					supplyISawAir = 400;
};
}
