#pragma once

#include "Common.h"
#include "InformationManager.h"
#include "StrategyManager.h"

namespace UAlbertaBot
{
class CombatCommander
{
    BWAPI::Unitset  _combatUnits;
    bool            _initialized;
	bool			_broodForce; //if set all units will attack regardless of simulation-results

	void			command();
	void			handleOverlords(BWAPI::Unit unitClosestToEnemy);
	int             getNumType(BWAPI::Unitset & units, BWAPI::UnitType type);
	double			getForcePower(std::vector<UnitInfo> units, std::vector<UnitInfo> enemyunits, BWAPI::Position pos, double& averageHPRatio, double meleeLowScoreDistance = 0, bool mine = false);

	UAlbertaBot::UnitInfo findClosestEnemy(BWAPI::Position pos, bool ignoreFlyers = false, bool iAmFlyer = false, bool considerRange = false);
	UAlbertaBot::UnitInfo findBestAttackTarget(BWAPI::Unit unit, BWAPI::Position pos, double radius);
    BWAPI::Unit     findClosestWorkerToTarget(BWAPI::Unitset & unitsToAssign, BWAPI::Unit target);

	BWAPI::Position getDefendLocation();
    BWAPI::Position getMainAttackLocation();
	BWAPI::Position getMyAttackLocation(BWAPI::Unit unit);

    int             numZerglingsInOurBase();
    bool            beingBuildingRushed();

	double			myTotalCost = 0;
	double			enemyTotalCost = 0;
public:

	CombatCommander();

	void update(const BWAPI::Unitset & combatUnits, double myCost = 0, double enemyCost = 0);
    
	void drawSquadInformation(int x, int y);
};
}
