#include "ZiabotModule.h"
#include "Manager.h"
#include <BWAPI.h>

using namespace BWAPI;
using namespace BWTA;
using namespace Filter;

bool debug = false;
Manager manager;

void ZiabotModule::onStart()
{
	Broodwar->enableFlag(Flag::UserInput);
	Broodwar->setCommandOptimizationLevel(2);

	BWTA::readMap();
	BWTA::analyze();

	for (auto &base : BWTA::getBaseLocations()) manager.push(base->getTilePosition());
	manager.start();
}
void ZiabotModule::onFrame()
{
	manager.refresh(debug);
}
void ZiabotModule::onSendText(std::string text)
{
	if (text == "/debug"){
		debug = true;
		Broodwar << "Debug mode on" << std::endl;
		Broodwar << Broodwar->enemy()->getRace().c_str() << endl;
	}
}
void ZiabotModule::onReceiveText(BWAPI::Player player, std::string text)
{
	
}
void ZiabotModule::onPlayerLeft(BWAPI::Player player)
{
	
}
void ZiabotModule::onNukeDetect(BWAPI::Position target)
{

}
void ZiabotModule::onUnitDiscover(BWAPI::Unit unit)
{
	if (IsEnemy(unit)){
		if (IsBuilding(unit) && !IsRefinery(unit)) manager.push(make_tuple(unit, unit->getPosition()));
		manager.push(unit);
	}
}
void ZiabotModule::onUnitEvade(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitShow(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitHide(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitCreate(BWAPI::Unit unit)
{
}
void ZiabotModule::onUnitComplete(BWAPI::Unit unit)
{
	manager.push(unit);
}
void ZiabotModule::onUnitDestroy(BWAPI::Unit unit)
{
	manager.pop(unit);
}
void ZiabotModule::onUnitMorph(BWAPI::Unit unit)
{
	
}
void ZiabotModule::onUnitRenegade(BWAPI::Unit unit)
{
}
void ZiabotModule::onSaveGame(std::string gameName)
{
	
}
void ZiabotModule::onEnd(bool isWinner)
{
	manager.end(isWinner);
}
