#include <iostream>
#include <BWAPI.h>
#include "Worker.h"
#include "BuildsInfo.h"

using namespace BWAPI;
using namespace Filter;
using namespace std;

//Order
bool Worker::refresh(vector<Unit> All_units, vector<Unit> ML_hatcheries, vector<Unit> Unsatisfied_hatcheries, BuildLocations BL, BuildInfo BI, tuple<Unit, TilePosition> hatchery, vector<Unit> geysers){
	Built.clear();
	for (auto& u : All_units){
		if (IsBuilding(u) && IsCompleted(u)){
			if (find(Built.begin(), Built.end(), u->getType()) == Built.end()){
				Built.push_back(u->getType());
			}
		}
	}
	this->mine(Unsatisfied_hatcheries);
	return this->build(All_units, ML_hatcheries, Unsatisfied_hatcheries, BL, BI, hatchery, geysers);
}
void Worker::mine(vector<Unit> hatcheries){
	if (hatcheries.empty()) return;

	// Let non scouter, builder, and special agent mine
	for (const auto& u : Drones){
		if (u.first->getType() != UnitTypes::Zerg_Drone){
			Drones.erase(u.first);
			break;
		}
		if (u.second == State::Work){
			Broodwar->drawCircleMap(u.first->getPosition(), 5, Colors::White, true);
			Unit drone = u.first;
			if (drone->isUnderAttack()){
				Unit Target = drone->getClosestUnit(IsEnemy && !IsFlying, drone->getType().groundWeapon().maxRange());
				if (Target){
					if (drone->getHitPoints() >= 20) drone->attack(Target);
					else{
						Position ppp;
						ppp.x = 4 * drone->getPosition().x - 3 * Target->getPosition().x;
						ppp.y = 4 * drone->getPosition().y - 3 * Target->getPosition().y;
						ppp.makeValid();
						drone->move(ppp);
					}
				}
				else{
					;
				}
			}
			else if (u.first->isIdle()){
				Unit drone = u.first;
				/*
				Unit h;
				int dist = 0;
				for (const auto& V : hatcheries){
					if (dist == 0){
						h = V;
						dist = drone->getDistance(V);
					}
					else if (dist > drone->getDistance(V)){
						h = V;
						dist = drone->getDistance(V);
					}
				}
				if (dist != 0) drone->gather(h->getClosestUnit(IsMineralField));
				if (dist == 0) */
				drone->gather(drone->getClosestUnit(IsMineralField));
			}
		}
	}
}
bool Worker::build(vector<Unit> All_units, vector<Unit> ML_hatcheries, vector<Unit> hatcheries, BuildLocations BL, BuildInfo BI, tuple<Unit, TilePosition> hatchery, vector<Unit> geysers){
	static vector<BuildsInfo> Info;
	vector<BuildsInfo> tInfo;
	bool res = false;

	vector<Unit> used_Drones;

	/* refreshing: isCompleted? */
	for (const auto& I : Info){
		if (find(used_Drones.begin(), used_Drones.end(), I.drone) != used_Drones.end()) continue;
		else used_Drones.push_back(I.drone);
		if (IsBuilding(I.drone) && I.drone->isCompleted()){
			Drones[I.drone] = State::Work;
			continue;
		}
		tInfo.push_back(I);
	}
	Info = tInfo;

	/* inserting BI into Info */
	for (const auto& I : BI.buildings){
		UnitType UT = I.first;
		int N = I.second;

		if (UT == UnitTypes::Zerg_Lair || UT == UnitTypes::Zerg_Hive || UT == UnitTypes::Zerg_Greater_Spire) continue;

		// Count Existing Buildings
		for (const auto& U : All_units){
			if (UT == U->getType()) N--;
		}
		// Count Ordered
		for (const auto& I : Info){
			if (I.UT == UT) N--;
		}
		// Add to Info as much as required
		if (N > 0){
			TilePosition tile;
			Unit drone;
			tie(tile, drone) = BL.getBL();
			if (!tile || !drone) continue;
			drone = drone->getClosestUnit(IsOwned && IsGatheringMinerals && !IsCarryingSomething, 400);
			if (drone && tile){
				if (Drones[drone] != State::Work) continue;
				Drones[drone] = State::Build;
				BuildsInfo BI(drone, UT, tile);
				Info.push_back(BI);
			}
		}
	}
	for (const auto& G : geysers){
		bool flag = false;
		for (const auto& I : Info){
			if (I.tile == G->getTilePosition()){
				flag = true;
				break;
			}
		}
		if (flag) continue;
		UnitType UT = UnitTypes::Zerg_Extractor;
		TilePosition tile = G->getTilePosition();
		Unit drone = G->getClosestUnit(IsOwned && IsGatheringMinerals && !IsCarryingSomething, 600);
		if (drone){
			if (Drones[drone] != State::Work) continue;
			Drones[drone] = State::Build;
			BuildsInfo BI(drone, UT, tile);
			Info.push_back(BI);
		}
	}
	if (true){
		/* hatchery */
		Unit builder;
		TilePosition tile;
		tie(builder, tile) = hatchery;
		if (builder != NULL){
			bool yes = true;
			for (const auto& I : Info){
				if (I.UT == UnitTypes::Zerg_Hatchery){
					yes = false;
					break;
				}
			}
			if (yes){
				BuildsInfo BI(builder, UnitTypes::Zerg_Hatchery, tile, Broodwar->getFrameCount());
				Info.push_back(BI);
			}
		}
	}

	//Actual Build
	tInfo.clear();
	for (const auto& I : Info){
		if (!I.drone) continue;
		if (!I.drone->exists()) continue;
		if (I.UT == UnitTypes::Zerg_Hatchery){
			if (I.frame + 2000 < Broodwar->getFrameCount()){
				Drones[I.drone] = State::Work;
				continue;
			}
			res = true;
		}

		TilePosition tp1 = I.tile;
		TilePosition tp2 = I.tile + I.UT.tileSize();
		Position p = (Position)(tp1 + tp2) / 2;
		if (Broodwar->self()->minerals() + 20 >= I.UT.mineralPrice() && Broodwar->self()->gas() + 20 >= I.UT.gasPrice() && canIt(I.UT)){
			bool flag = false;
			if (I.drone->getLastCommandFrame() + 5 > Broodwar->getFrameCount()) flag = true;
			if (!flag){
				if (I.drone->getDistance(p) > 100) I.drone->move(p);
				I.drone->build(I.UT, I.tile);
			}
			if (I.UT == UnitTypes::Zerg_Hatchery){
				Unit Overlord = I.drone->getClosestUnit(IsOwned && !IsBlind && GetType == UnitTypes::Zerg_Overlord);
				if (Overlord) Overlord->move(I.drone->getPosition());
			}
		}
		else{
			Unit drone = I.drone;
			Unit h;
			int dist = 0;
			for (const auto& V : hatcheries){
				if (dist == 0){
					h = V;
					dist = drone->getDistance(V);
				}
				else if (dist > drone->getDistance(V)){
					h = V;
					dist = drone->getDistance(V);
				}
			}
			if (h && !drone->isGatheringMinerals()){
				Unit m = h->getClosestUnit(IsMineralField);
				if(m)drone->gather(m);
			}
		}
		if (!Broodwar->canBuildHere(I.tile, I.UT, I.drone)){
			Drones[I.drone] = State::Work;
			continue;
		}

		Unit u = I.drone;
		UnitType ut = I.UT;

		Broodwar->registerEvent([u, ut, tp1, tp2](Game*)
		{
			Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Blue, true);
			Broodwar->drawBoxMap((Position)tp1, (Position)tp2, Colors::Orange);
			Broodwar->drawTextMap(u->getPosition(), "%s", ut.c_str());
		}, nullptr, Broodwar->getLatencyFrames());

		tInfo.push_back(I);
	}
	Info = tInfo;
	return res;
}

//Sub-order
bool Worker::canIt(UnitType UT){
	for (auto& m : UT.requiredUnits()){
		if (m.first == UnitTypes::None || !m.first.isBuilding()) continue;
		bool hasIt = false;
		for (auto& u : Built){
			if (m.first == u){
				hasIt = true;
				break;
			}
		}
		if (!hasIt) return false;
	}
	return true;
}

//Unit Manage
void Worker::push(Unit u)
{ Drones[u] = State::Work; }
void Worker::pop(Unit u)
{ Drones.erase(u); }