#pragma once
#include <BWAPI.h>
#include <iostream>
#include "BuildLocation.h"

using namespace BWAPI;
using namespace std;


/* Defense System */
class Pascal{
public:
	vector<Position> eGPosition; // enemy Ground
	vector<Position> eSPosition; // enemy Flying
	vector<Unit> building;
	map<Unit, Position> targetedFrom;
	vector<tuple<Unit, Position>> enemy_ground;
	vector<tuple<Unit, Position>> enemy_sky;

	bool isInRange(Unit);
};


class Squad{
public:
	Pascal pascaL;
	UnitType Type;
	vector<Unit> squad;
public:
	Squad(UnitType UT, Pascal p) : Type(UT), pascaL(p) {}
	void push(Unit);
	void pop(vector<Unit>::iterator);

	void Attack(Position, int N);
	void Hold(Position, int);
	void Defense(Position, int);

	void setPascal(Pascal p){ pascaL = p; }
};

class SquadManager{
public:
	Pascal pascaL;
	map<UnitType, int> UTmap;
	vector<tuple<Unit, Position>> ebuilding;
	vector<Unit> unit; // squads & overlords
	vector<Unit> overlord;
	vector<Squad> squad;
public:
	void push(Unit);
	void push(tuple<Unit, Position>);
	void pop(Unit);

	void cycle(bool rush, BuildLocations forSearch, map<UnitType, int> Unit_counts);
	bool search(BuildLocations, Unit, int starting);
	void Overlord();
	void eRefresh();

	bool Defense();

	bool Defend(Squad);
	void Attack(Squad);
	void Hold(Squad);
};