#include <iostream>
#include <BWAPI.h>
#include <BWTA.h>
#include "Squad.h"
#include "BuildLocation.h"

using namespace BWAPI;
using namespace Filter;
using namespace std;

// Squad

void Squad::push(Unit u)
{squad.push_back(u);}

void Squad::pop(vector<Unit>::iterator UI)
{squad.erase(UI);}

void Squad::Attack(Position ave, int N){
	Unit target = NULL;
	bool ranged = false; // Sky attackable
	bool rangeD = false; // attackable
	Position ppp; // for Mutal 
	Unit Home = NULL;
	int HP = 100;
	int ranged_dist = 100000;
	Unit egg = NULL;
	int ddd = 100000;
	if (Type == UnitTypes::Zerg_Zergling){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 5 + N / 10 > Broodwar->getFrameCount()) continue;

			Unit target = NULL;
			int dist = 0;

			for (const auto& ee : u->getUnitsInRadius(224)){
				if (!IsVisible(ee) || !IsEnemy(ee) || IsFlying(ee)) continue;
				if (ee->getType().groundWeapon().damageAmount() == 0 && ee->getType() != UnitTypes::Terran_Bunker) continue;
				if (ee->getType() == UnitTypes::Terran_Bunker || ee->getType() == UnitTypes::Protoss_Photon_Cannon || ee->getType() == UnitTypes::Zerg_Sunken_Colony);
				if (target == NULL){
					target = ee;
					dist = u->getDistance(ee);
				}
				else if (u->getDistance(ee) < dist){
					target = ee;
					dist = target->getDistance(u);
				}
			}
			if (target){
				if (target->getType().groundWeapon().damageAmount() > 0 || target->getType() == UnitTypes::Terran_Bunker){
					u->attack(target);
					continue;
				}
			}
			else {
				target = u->getClosestUnit(IsEnemy&&!IsFlying&&GetType != UnitTypes::Zerg_Larva&&GetType != UnitTypes::Zerg_Egg&&GetType != UnitTypes::Zerg_Lurker_Egg);
				if (target)
					u->attack(target);
				else
					u->attack(ave);
				continue;
			}
		}
	}
	else if (Type == UnitTypes::Zerg_Hydralisk){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 5 + N / 10 > Broodwar->getFrameCount()) continue;
			Unit uu = NULL;
			int uud = 100000;
			enum Hydra { Evade, Attack, Chase, Charge };
			int Heil_Hydra = Hydra::Charge;
			for (auto& ee : u->getUnitsInRadius(320)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (egg == NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg){
						egg = ee;
						ddd = u->getDistance(ee);
					}
					else if (egg != NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg && u->getDistance(ee) < ddd){
						egg = ee;
						ddd = u->getDistance(ee);
					}
				}
				if (!IsEnemy(ee) || !ee->isVisible(Broodwar->self())) continue;
				if (((ee->isFlying() && u->getDistance(ee) <= u->getType().airWeapon().maxRange() * 4 / 10)
					|| (!ee->isFlying() && u->getDistance(ee) <= u->getType().groundWeapon().maxRange() * 4 / 10))
					&& ee->getType().groundWeapon().damageAmount() > 0){
					Position ppp;
					ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
					ppp.makeValid();
					u->attack(ppp);
					Heil_Hydra = Hydra::Evade;
					break;
				}
				if (ee->getType().groundWeapon().damageAmount() > 0 && u->isInWeaponRange(ee)){
					if (Heil_Hydra == Hydra::Attack){
						if (ee->getHitPoints() < HP){
							target = ee;
							HP = ee->getHitPoints();
						}
					}
					else{
						target = ee;
						HP = ee->getHitPoints();
						Heil_Hydra = Hydra::Attack;
					}
				}
				if (Heil_Hydra == Hydra::Charge && ee->getType().groundWeapon().damageAmount() > 0){
					target = ee;
					Heil_Hydra = Hydra::Chase;
				}
				if (Heil_Hydra == Hydra::Charge && u->isInWeaponRange(ee) && !IsBuilding(ee) && (!uu || uud > u->getDistance(ee))){
					uu = ee;
					uud = u->getDistance(ee);
				}
			}
			switch (Heil_Hydra){
			case Hydra::Attack:
				u->attack(target);
				break;
			case Hydra::Chase:
				u->attack(target);
				break;
			case Hydra::Charge:
				target = u->getClosestUnit(IsEnemy && IsBuilding);
				if (egg){
					u->attack(egg);
				}
				else if (uu){
					u->attack(uu->getPosition());
				}
				else if (target){
					u->attack(target->getPosition());
				}
				else if (u->isIdle()){
					u->attack(ave);
				}
				break;
			}
		}
	}
	else if (Type == UnitTypes::Zerg_Lurker){
		for (auto& u : squad){
			Unit egg;
			int egg2 = 0;
			if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
				egg = u->getClosestUnit(GetType == UnitTypes::Zerg_Egg && !IsOwned);
				if (u->isBurrowed() && egg){
					if (u->isInWeaponRange(egg)){
						u->attack(egg);
					}
				}
			}
			if (u->canUnburrow() && Broodwar->getFrameCount() - 300 <= u->getLastCommandFrame()) continue;
			if (u->canBurrow() && Broodwar->getFrameCount() - 5 <= u->getLastCommandFrame()) continue;
			bool EE = false;
			for(auto& target : u->getUnitsInRadius(190)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (!IsEnemy(target) && !IsOwned(target) && target->getType() == UnitTypes::Zerg_Egg){
						egg2++;
						if (egg2 > 1){
							EE = true;
							if (u->canBurrow()){
								u->burrow();
								break;
							}
						}
					}
				}
				if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
				EE = true;
				if (u->canBurrow()){
					u->burrow();
					break;
				}
			}
			if (!EE && u->canUnburrow()) u->unburrow();
			else{
				u->move(ave);
			}
			continue;
		}
	}
	else if (Type == UnitTypes::Zerg_Mutalisk){
		bool capt = true;
		for (auto& u : squad){
			if (capt){ // targeting
				Home = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
				if (!Home) Home = u->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Hatchery);
				for (auto& ranger : u->getUnitsInRadius(256)){
					if (!ranger->isVisible(Broodwar->self())) continue;
					if (ranger->getType() == UnitTypes::Zerg_Larva || ranger->getType() == UnitTypes::Zerg_Egg || ranger->getType() == UnitTypes::Zerg_Lurker_Egg) continue;
					if (!IsEnemy(ranger) || !u->canAttackUnit(ranger) || !u->canRightClickUnit(ranger))continue;

					//if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && HP > ranger->getHitPoints()){
					if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && ranged_dist > u->getDistance(ranger)){
						target = ranger;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && (ranger->getType().airWeapon().damageAmount() > 0 || ranger->getType() == UnitTypes::Terran_Bunker)){
						target = ranger;
						ranged = true;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && rangeD && HP > ranger->getHitPoints()){
						target = ranger;
						HP = ranger->getHitPoints();
					}
					else if (!ranged && !rangeD && ranger->getType().groundWeapon().damageAmount() > 0){
						target = ranger;
						rangeD = true;
						HP = ranger->getHitPoints();
					}
					else if (target == NULL || (!ranged && !rangeD && HP > ranger->getHitPoints())){
						target = ranger;
						HP = ranger->getHitPoints();
					}
				}
				//if (!target) target = u->getClosestUnit(IsEnemy);
				if (!target) target = Home;
				if (ranged && target){
					ppp.x = 4 * u->getPosition().x - 3 * target->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * target->getPosition().y;
					ppp.makeValid();
				}
				capt = false;
			}
			if (u->getLastCommandFrame() + 5 > Broodwar->getFrameCount() && u->getLastCommand().getType() == UnitCommandTypes::Patrol) continue;
			if (target != Home && target){
				if (!u->isInWeaponRange(target)) u->attack(target->getPosition());
				else if (u->getDistance(target) < 85 && ranged){
					//u->attack(target);
					u->patrol(target->getPosition());
					u->move(ppp);
				}
				else u->attack(target);
			}
			else{
				u->attack(ave);
			}
		}
	}
}

void Squad::Hold(Position ave, int N){
	Unit target = NULL;
	bool ranged = false; // Sky attackable
	bool rangeD = false; // attackable
	Position ppp; // for Mutal 
	Unit Home = NULL;
	int HP = 100;
	int ranged_dist = 100000;
	Unit egg = NULL;
	int ddd = 100000;
	if (Type == UnitTypes::Zerg_Zergling){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 5 + N / 10 > Broodwar->getFrameCount()) continue;

			Home = u->getClosestUnit(IsOwned && IsBuilding);
			Unit target = u->getClosestUnit(IsEnemy && !IsFlying && GetType != UnitTypes::Zerg_Larva && GetType != UnitTypes::Zerg_Egg && GetType != UnitTypes::Zerg_Lurker_Egg);
			if (target){
				int enemy, ally;
				enemy = ally = 0;
				for (auto& U : target->getUnitsInRadius(300)){
					if (IsEnemy(U)) enemy++;
					if (IsOwned(U)) ally++;
				}
				if (enemy * 3 <= ally){
					u->attack(target);
					continue;
				}
			}
			if (pascaL.isInRange(u)){
				Position ppp;
				ppp.x = 4 * u->getPosition().x - 3 * pascaL.targetedFrom[u].x;
				ppp.y = 4 * u->getPosition().y - 3 * pascaL.targetedFrom[u].y;
				ppp.makeValid();
				u->move(ppp);
			}
			else{
				if (target)
					u->attack(target);
				else
					u->attack(ave);
			}
		}
	}
	else if (Type == UnitTypes::Zerg_Hydralisk){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 6 + N / 10 > Broodwar->getFrameCount()) continue;
			Unit target = u->getClosestUnit(IsEnemy && GetType != UnitTypes::Zerg_Larva && GetType != UnitTypes::Zerg_Egg && GetType != UnitTypes::Zerg_Lurker_Egg);
			if (target){
				int enemy, ally;
				enemy = ally = 0;
				for (auto& U : target->getUnitsInRadius(300)){
					if (IsEnemy(U)) enemy++;
					if (IsOwned(U)) ally++;
				}
				if (enemy * 3 <= ally){
					u->attack(target);
					continue;
				}
			}
			if (pascaL.isInRange(u)){
				Position ppp;
				ppp.x = 4 * u->getPosition().x - 3 * pascaL.targetedFrom[u].x;
				ppp.y = 4 * u->getPosition().y - 3 * pascaL.targetedFrom[u].y;
				ppp.makeValid();
				u->move(ppp);
			}
			else{
				Unit target = u->getClosestUnit(IsEnemy&& GetType != UnitTypes::Zerg_Larva && GetType != UnitTypes::Zerg_Egg && GetType != UnitTypes::Zerg_Lurker_Egg);

				if (target)
					u->attack(target);
				else
					u->attack(ave);
			}
		}
	}
	else if (Type == UnitTypes::Zerg_Lurker){
		for (auto& u : squad){
			Unit egg;
			int egg2 = 0;
			if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
				egg = u->getClosestUnit(GetType == UnitTypes::Zerg_Egg && !IsOwned);
				if (u->isBurrowed() && egg){
					if (u->isInWeaponRange(egg)){
						u->attack(egg);
					}
				}
			}
			if (u->canUnburrow() && Broodwar->getFrameCount() - 300 <= u->getLastCommandFrame()) continue;
			if (u->canBurrow() && Broodwar->getFrameCount() - 5 <= u->getLastCommandFrame()) continue;

			if (pascaL.isInRange(u)){
				u->burrow();
				continue;
			}

			bool EE = false;
			for (auto& target : u->getUnitsInRadius(190)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (!IsEnemy(target) && !IsOwned(target) && target->getType() == UnitTypes::Zerg_Egg){
						egg2++;
						if (egg2 > 1){
							EE = true;
							if (u->canBurrow()){
								u->burrow();
								break;
							}
						}
					}
				}
				if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
				EE = true;
				if (u->canBurrow()){
					u->burrow();
					break;
				}
			}
			if (!EE && u->canUnburrow()) u->unburrow();
			else{
				u->move(ave);
			}
			continue;
		}
	}
	else if (Type == UnitTypes::Zerg_Mutalisk){
		bool capt = true;
		for (auto& u : squad){
			if (capt){ // targeting
				Home = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
				if (!Home) Home = u->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Hatchery);
				for (auto& ranger : u->getUnitsInRadius(256)){
					if (!ranger->isVisible(Broodwar->self())) continue;
					if (ranger->getType() == UnitTypes::Zerg_Larva || ranger->getType() == UnitTypes::Zerg_Egg || ranger->getType() == UnitTypes::Zerg_Lurker_Egg) continue;
					if (!IsEnemy(ranger) || !u->canAttackUnit(ranger) || !u->canRightClickUnit(ranger))continue;

					//if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && HP > ranger->getHitPoints()){
					if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && ranged_dist > u->getDistance(ranger)){
						target = ranger;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && (ranger->getType().airWeapon().damageAmount() > 0 || ranger->getType() == UnitTypes::Terran_Bunker)){
						target = ranger;
						ranged = true;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && rangeD && HP > ranger->getHitPoints()){
						target = ranger;
						HP = ranger->getHitPoints();
					}
					else if (!ranged && !rangeD && ranger->getType().groundWeapon().damageAmount() > 0){
						target = ranger;
						rangeD = true;
						HP = ranger->getHitPoints();
					}
					else if (target == NULL || (!ranged && !rangeD && HP > ranger->getHitPoints())){
						target = ranger;
						HP = ranger->getHitPoints();
					}
				}
				//if (!target) target = u->getClosestUnit(IsEnemy);
				if (!target) target = Home;
				if (ranged && target){
					ppp.x = 4 * u->getPosition().x - 3 * target->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * target->getPosition().y;
					ppp.makeValid();
				}
				capt = false;
			}
			if (u->getLastCommandFrame() + 5 > Broodwar->getFrameCount() && u->getLastCommand().getType() == UnitCommandTypes::Patrol) continue;
			if (!pascaL.isInRange(u)){
				if (target)
					u->attack(target);
				else
					u->attack(ave);
			}
			else{
				Position ppp;
				ppp.x = 4 * u->getPosition().x - 3 * pascaL.targetedFrom[u].x;
				ppp.y = 4 * u->getPosition().y - 3 * pascaL.targetedFrom[u].y;
				ppp.makeValid();
				u->move(ppp);
			}
		}
	}
}

void Squad::Defense(Position ave, int N){
	Unit target = NULL;
	bool ranged = false; // Sky attackable
	bool rangeD = false; // attackable
	Position ppp; // for Mutal 
	Unit Home = NULL;
	int HP = 100;
	int ranged_dist = 100000;
	Unit egg = NULL;
	int ddd = 100000;
	if (Type == UnitTypes::Zerg_Zergling){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 5 + N / 10 > Broodwar->getFrameCount()) continue;

			Unit target = NULL;
			int dist = 0;

			for (const auto& ee : u->getUnitsInRadius(224)){
				if (!IsVisible(ee) || !IsEnemy(ee) || IsFlying(ee)) continue;
				if (ee->getType().groundWeapon().damageAmount() == 0 && ee->getType() != UnitTypes::Terran_Bunker) continue;
				if (ee->getType() == UnitTypes::Terran_Bunker || ee->getType() == UnitTypes::Protoss_Photon_Cannon || ee->getType() == UnitTypes::Zerg_Sunken_Colony);
				if (target == NULL){
					target = ee;
					dist = u->getDistance(ee);
				}
				else if (u->getDistance(ee) < dist){
					target = ee;
					dist = target->getDistance(u);
				}
			}
			if (target){
				if (target->getType().groundWeapon().damageAmount() > 0 || target->getType() == UnitTypes::Terran_Bunker){
					u->attack(target);
					continue;
				}
			}
			else
				u->attack(ave);
		}
	}
	else if (Type == UnitTypes::Zerg_Hydralisk){
		for (auto& u : squad){
			if (u->getLastCommandFrame() + 6 + N / 10 > Broodwar->getFrameCount()) continue;
			Unit uu = NULL;
			int uud = 100000;
			enum Hydra { Evade, Attack, Chase, Charge };
			int Heil_Hydra = Hydra::Charge;
			for (auto& ee : u->getUnitsInRadius(256)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (egg == NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg){
						egg = ee;
						ddd = u->getDistance(ee);
					}
					else if (egg != NULL && !IsEnemy(ee) && !IsOwned(ee) && ee->getType() == UnitTypes::Zerg_Egg && u->getDistance(ee) < ddd){
						egg = ee;
						ddd = u->getDistance(ee);
					}
				}
				if (!IsEnemy(ee) || !ee->isVisible(Broodwar->self())) continue;
				if (((ee->isFlying() && u->getDistance(ee) <= u->getType().airWeapon().maxRange() * 4 / 10)
					|| (!ee->isFlying() && u->getDistance(ee) <= u->getType().groundWeapon().maxRange() * 4 / 10))
					&& ee->getType().groundWeapon().damageAmount() > 0){
					Position ppp;
					ppp.x = 4 * u->getPosition().x - 3 * ee->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * ee->getPosition().y;
					ppp.makeValid();
					u->attack(ppp);
					Heil_Hydra = Hydra::Evade;
					break;
				}
				if (ee->getType().groundWeapon().damageAmount() > 0 && u->isInWeaponRange(ee)){
					if (Heil_Hydra == Hydra::Attack){
						if (ee->getHitPoints() < HP){
							target = ee;
							HP = ee->getHitPoints();
						}
					}
					else{
						target = ee;
						HP = ee->getHitPoints();
						Heil_Hydra = Hydra::Attack;
					}
				}
				if (Heil_Hydra == Hydra::Charge && ee->getType().groundWeapon().damageAmount() > 0){
					target = ee;
					Heil_Hydra = Hydra::Chase;
				}
				if (Heil_Hydra == Hydra::Charge && u->isInWeaponRange(ee) && !IsBuilding(ee) && (!uu || uud > u->getDistance(ee))){
					uu = ee;
					uud = u->getDistance(ee);
				}
			}
			switch (Heil_Hydra){
			case Hydra::Attack:
				u->attack(target);
				break;
			case Hydra::Chase:
				u->attack(target);
				break;
			case Hydra::Charge:
				target = u->getClosestUnit(IsEnemy && IsBuilding);
				if (egg){
					u->attack(egg);
				}
				else if (uu){
					u->attack(uu->getPosition());
				}
				else if (target){
					u->attack(target->getPosition());
				}
				else if (u->isIdle()){
					u->attack(ave);
				}
				break;
			}
		}
	}
	else if (Type == UnitTypes::Zerg_Lurker){
		for (auto& u : squad){
			Unit egg;
			int egg2 = 0;
			if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
				egg = u->getClosestUnit(GetType == UnitTypes::Zerg_Egg && !IsOwned);
				if (u->isBurrowed() && egg){
					if (u->isInWeaponRange(egg)){
						u->attack(egg);
					}
				}
			}
			if (u->canUnburrow() && Broodwar->getFrameCount() - 300 <= u->getLastCommandFrame()) continue;
			if (u->canBurrow() && Broodwar->getFrameCount() - 5 <= u->getLastCommandFrame()) continue;
			bool EE = false;
			for (auto& target : u->getUnitsInRadius(190)){
				if (Broodwar->mapFileName() == "(3)Plasma1.0.scx"){
					if (!IsEnemy(target) && !IsOwned(target) && target->getType() == UnitTypes::Zerg_Egg){
						egg2++;
						if (egg2 > 1){
							EE = true;
							if (u->canBurrow()){
								u->burrow();
								break;
							}
						}
					}
				}
				if (!IsEnemy(target) || !IsVisible(target) || IsFlying(target)) continue;
				EE = true;
				if (u->canBurrow()){
					u->burrow();
					break;
				}
			}
			if (!EE && u->canUnburrow()) u->unburrow();
			else{
				u->move(ave);
			}
			continue;
		}
	}
	else if (Type == UnitTypes::Zerg_Mutalisk){
		bool capt = true;
		for (auto& u : squad){
			if (capt){ // targeting
				Home = u->getClosestUnit(IsOwned && (GetType == UnitTypes::Zerg_Creep_Colony || GetType == UnitTypes::Zerg_Sunken_Colony));
				if (!Home) Home = u->getClosestUnit(IsOwned && GetType == UnitTypes::Zerg_Hatchery);
				for (auto& ranger : u->getUnitsInRadius(256)){
					if (!ranger->isVisible(Broodwar->self())) continue;
					if (ranger->getType() == UnitTypes::Zerg_Larva || ranger->getType() == UnitTypes::Zerg_Egg || ranger->getType() == UnitTypes::Zerg_Lurker_Egg) continue;
					if (!IsEnemy(ranger) || !u->canAttackUnit(ranger) || !u->canRightClickUnit(ranger))continue;

					//if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && HP > ranger->getHitPoints()){
					if (ranged && ranger->getType().airWeapon().damageAmount() > 0 && ranged_dist > u->getDistance(ranger)){
						target = ranger;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && (ranger->getType().airWeapon().damageAmount() > 0 || ranger->getType() == UnitTypes::Terran_Bunker)){
						target = ranger;
						ranged = true;
						//HP = ranger->getHitPoints();
						ranged_dist = u->getDistance(ranger);
					}
					else if (!ranged && rangeD && HP > ranger->getHitPoints()){
						target = ranger;
						HP = ranger->getHitPoints();
					}
					else if (!ranged && !rangeD && ranger->getType().groundWeapon().damageAmount() > 0){
						target = ranger;
						rangeD = true;
						HP = ranger->getHitPoints();
					}
					else if (target == NULL || (!ranged && !rangeD && HP > ranger->getHitPoints())){
						target = ranger;
						HP = ranger->getHitPoints();
					}
				}
				//if (!target) target = u->getClosestUnit(IsEnemy);
				if (!target) target = Home;
				if (ranged && target){
					ppp.x = 4 * u->getPosition().x - 3 * target->getPosition().x;
					ppp.y = 4 * u->getPosition().y - 3 * target->getPosition().y;
					ppp.makeValid();
				}
				capt = false;
			}
			if (u->getLastCommandFrame() + 5 > Broodwar->getFrameCount() && u->getLastCommand().getType() == UnitCommandTypes::Patrol) continue;
			if (target != Home && target){
				if (!u->isInWeaponRange(target)) u->attack(target->getPosition());
				else if (u->getDistance(target) < 85 && ranged){
					//u->attack(target);
					u->patrol(target->getPosition());
					u->move(ppp);
				}
				else u->attack(target);
			}
			else{
				u->attack(ave);
			}
		}
	}
}

// SquadManager

void SquadManager::cycle(bool rush, BuildLocations BL, map<UnitType, int> UiMap){
	if (rush) Broodwar->drawTextScreen(200, 0, "Attack on");
	/* Defense system */
	eRefresh();
	bool D = Defense();

	UTmap = UiMap;
	static bool startings = true;
	static int starting = 0; // the most recent visited SL
	if (startings){
		startings = false;
		for (int i = 0; i < BL.SL; i++){
			if (BL.startlocations[i] == Broodwar->self()->getStartLocation()) continue;
			if (!Broodwar->isVisible(BL.startlocations[i])){
				startings = true;
				break;
			}
		}
	}
	vector<tuple<Unit, Position>> tbuilding;
	for (auto& E : ebuilding){
		Unit U;
		Position P;
		tie(U, P) = E;
		TilePosition T = (TilePosition)P;
		if (Broodwar->isVisible(T) && !U->isVisible()) continue;
		Broodwar->drawCircleMap(P, 5, Colors::Red, true);
		tbuilding.push_back(E);
	}
	ebuilding = tbuilding;
	if (ebuilding.size() == 0){ // Searching
		bool BREAK = false;
		for (auto& u : unit){
			if (u->isIdle()){
				if (startings){
					for (int i = (starting + 1) % BL.SL;; i = (i + 1) % BL.SL){
						if (i == starting){
							starting = (starting + 1) % BL.SL;
							break;
						}
						if (Broodwar->isVisible(BL.startlocations[i])){
							if (BL.startflag[i] == false){
								BL.startflag[i] = true;
								for (auto& U : unit){
									search(BL, U, starting);
									BREAK = true;
								}
								break;
							}
							else
								continue;
						}
						if (u->isIdle() && (BWTA::isConnected(u->getTilePosition(), BL.startlocations[i]) || u->isFlying())){
							Position p = (Position)BL.startlocations[i];
							if(!u->canAttack()) u->move(p);
							else u->attack(p);
						}
					}
					if (BREAK){
						break;
					}
				}
				else{
					Position p = (Position)BL.getML();
					if (!u->canAttack()) u->move(p);
					else u->attack(p);
				}
			}
		}
	}
	else{
		vector<Squad> tSquad;
		for (auto& sq : squad){
			if (sq.squad.size() == 0) continue;
			sq.setPascal(pascaL);
			if (D){
				if (Defend(sq)){
					tSquad.push_back(sq);
					continue;
				}
			}
			if(rush) Attack(sq);
			else Hold(sq);
			tSquad.push_back(sq);
		}
		squad = tSquad;
	}
	Overlord();
}

void SquadManager::Overlord(){
	for (auto& u : overlord){
		if (u->isBlind()){
			u->move(u->getClosestUnit(IsOwned && IsBuilding)->getPosition());
			continue;
		}
		bool evade = true;
		for (auto& e : u->getUnitsInRadius(296)){
			if (IsOwned(e)) evade = false;
			if (!IsEnemy(e)) continue;
			if (e->getType().airWeapon().damageAmount() > 0 && evade){
				Position ppp;
				ppp.x = 4 * u->getPosition().x - 3 * e->getPosition().x;
				ppp.y = 4 * u->getPosition().y - 3 * e->getPosition().y;
				ppp.makeValid();
				u->move(ppp);
				break;
			}
		}
	}
}

bool SquadManager::search(BuildLocations BL, Unit u, int starting){
	int dist = -1;
	Position p;
	for (int i = (starting + 1) % BL.SL;; i = (i + 1) % BL.SL){
		if (i == starting) break;
		if (Broodwar->isVisible(BL.startlocations[i]) || BL.startflag[i]) continue;
		if (dist < 0 || dist > u->getDistance((Position)BL.startlocations[i])){
			dist = u->getDistance((Position)BL.startlocations[i]);
			p = (Position)BL.startlocations[i];
		}
	}
	if (dist == -1) return false;
	if (u->getType().isWorker()) return false;
	if (!u->canAttack()) u->move(p);
	else u->attack(p);
	return true;
}

void SquadManager::Attack(Squad sq){
	int dist = -1;
	Position ave;
	Unit C = sq.squad.front();
	if (!C) return;
	Unit Overlord = C->getClosestUnit(IsOwned && !IsBlind && GetType == UnitTypes::Zerg_Overlord);
	if (Overlord) Overlord->move(C->getPosition());
	for (const auto& E : ebuilding){
		Unit targetU;
		Position targetP;
		tie(targetU, targetP) = E;
		if (dist < 0 || dist > C->getDistance(targetP)){
			dist = C->getDistance(targetP);
			ave = targetP;
		}
	}
	sq.Attack(ave, UTmap[sq.Type]);
}

void SquadManager::Hold(Squad sq){
	int dist = -1;
	Position ave;
	Unit C = sq.squad.front();
	if (!C) return;
	Unit Overlord = C->getClosestUnit(IsOwned && !IsBlind && GetType == UnitTypes::Zerg_Overlord);
	if (Overlord) Overlord->move(C->getPosition());
	for (const auto& E : ebuilding){
		Unit targetU;
		Position targetP;
		tie(targetU, targetP) = E;
		if (dist < 0 || dist > C->getDistance(targetP)){
			dist = C->getDistance(targetP);
			ave = targetP;
		}
	}
	sq.Hold(ave, UTmap[sq.Type]);
}

bool SquadManager::Defend(Squad sq){
	int dist = -1;
	Position ave;
	Unit C = sq.squad.front();
	if (!C) return false;
	Unit Overlord = C->getClosestUnit(IsOwned && !IsBlind && GetType == UnitTypes::Zerg_Overlord);
	if (Overlord) Overlord->move(C->getPosition());

	if (C->getType().groundWeapon() > 0){
		for (auto& p : pascaL.eGPosition){
			if (dist < 0 || dist > C->getDistance(p)){
				dist = C->getDistance(p);
				ave = p;
			}
		}
	}
	if (C->getType().airWeapon() > 0){
		for (auto& p : pascaL.eSPosition){
			if (dist < 0 || dist > C->getDistance(p)){
				dist = C->getDistance(p);
				ave = p;
			}
		}
	}
	sq.Defense(ave, UTmap[sq.Type]);
	if (dist == -1) return false;
	else return true;
}

void SquadManager::push(Unit u){
	if (u->getType() == UnitTypes::Zerg_Larva || u->getType() == UnitTypes::Zerg_Egg) return;
	if (IsEnemy(u)){
		if (u->getType().groundWeapon().damageAmount() > 0){
			bool yes = true;
			for (auto& E : pascaL.enemy_ground){
				Unit e = get<0>(E);
				if (u == e){
					yes = false;
					break;
				}
			}
			if (yes) pascaL.enemy_ground.push_back(make_tuple(u, u->getPosition()));
		}
		if (u->getType().airWeapon().damageAmount() > 0){
			bool yes = true;
			for (auto& E : pascaL.enemy_sky){
				Unit e = get<0>(E);
				if (u == e){
					yes = false;
					break;
				}
			}
			if (yes) pascaL.enemy_sky.push_back(make_tuple(u, u->getPosition()));
		}
		return;
	}
	if (IsBuilding(u)){
		if (std::find(pascaL.building.begin(), pascaL.building.end(), u) == pascaL.building.end())
			pascaL.building.push_back(u);
		return;
	}
	unit.push_back(u);
	if (u->getType() == UnitTypes::Zerg_Overlord){
		overlord.push_back(u);
		return;
	}
	for (auto& Sq : squad){
		if (Sq.Type == u->getType() && Sq.squad.size() < 18){
			Sq.push(u);
			return;
		}
	}
	Squad neoSq(u->getType(), pascaL);
	neoSq.push(u);
	squad.push_back(neoSq);
}

void SquadManager::push(tuple<Unit, Position> tupe){
	bool found = false;
	Unit U;
	Position P;
	tie(U, P) = tupe;
	vector<tuple<Unit, Position>> tbuilding;
	for (auto& t : ebuilding){
		Unit u;
		Position p;
		tie(u, p) = t;
		if (U == u){
			found = true;
			p = P;
			tbuilding.push_back(make_tuple(u, p));
		}
		else tbuilding.push_back(t);
	}
	ebuilding = tbuilding;
	if (!found) ebuilding.push_back(tupe);
}

void SquadManager::pop(Unit u){
	if (IsEnemy(u)){
		if (u->getType().groundWeapon().damageAmount() > 0){
			vector<tuple<Unit, Position>> tground;
			for (auto& E : pascaL.enemy_ground){
				Unit e = get<0>(E);
				if (e == u) continue;
				tground.push_back(E);
			}
			pascaL.enemy_ground = tground;
		}
		if (u->getType().airWeapon().damageAmount() > 0){
			vector<tuple<Unit, Position>> tsky;
			for (auto& E : pascaL.enemy_sky){
				Unit e = get<0>(E);
				if (e == u) continue;
				tsky.push_back(E);
			}
			pascaL.enemy_ground = tsky;
		}
		return;
	}
	// IsOwned
	// Delete from unit;
	if (find(unit.begin(), unit.end(), u) != unit.end())
		unit.erase(find(unit.begin(), unit.end(), u));
		// Delete from overload
	if (find(overlord.begin(), overlord.end(), u) != overlord.end())
		overlord.erase(find(overlord.begin(), overlord.end(), u));
		// Delete from squad
	else{
		vector<Squad>::iterator SI;
		for (SI = squad.begin(); SI != squad.end(); ++SI){
			if (SI->Type == u->getType()){
				vector<Unit>::iterator UI;
				for (UI = SI->squad.begin(); UI != SI->squad.end(); ++UI){
					if (u == *UI){
						SI->pop(UI);
						return;
					}
				}
			}
		}
	}
}

void SquadManager::eRefresh(){
	vector<tuple<Unit, Position>> tground;
	for (auto& E : pascaL.enemy_ground){
		Unit u;
		Position p;
		tie(u, p) = E;
		if (IsVisible(u)){
			Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Red, true);
			Broodwar->drawCircleMap(u->getPosition(), u->getType().groundWeapon().maxRange() + (int)(u->getType().groundWeapon().maxRange() > 0) * 96 + (int)(u->getType().groundWeapon().maxRange() > 192) * 32, Colors::Red);
			tground.push_back(make_tuple(u, u->getPosition()));
			continue;
		}
		Broodwar->drawCircleMap(p, 5, Colors::Red, true);
		Broodwar->drawCircleMap(p, u->getType().groundWeapon().maxRange() + (int)(u->getType().groundWeapon().maxRange() > 0) * 96 + (int)(u->getType().groundWeapon().maxRange() > 192) * 32, Colors::Red);
		tground.push_back(E);
	}
	pascaL.enemy_ground = tground;

	vector<tuple<Unit, Position>> tsky;
	for (auto& E : pascaL.enemy_sky){
		Unit u;
		Position p;
		tie(u, p) = E;
		if (IsVisible(u)){
			Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Red, true);
			Broodwar->drawCircleMap(u->getPosition(), u->getType().airWeapon().maxRange() + (int)(u->getType().airWeapon().maxRange() > 0) * 96 + (int)(u->getType().airWeapon().maxRange() > 192) * 32, Colors::Red);
			tsky.push_back(make_tuple(u, u->getPosition()));
			continue;
		}
		Broodwar->drawCircleMap(p, 5, Colors::Red, true);
		Broodwar->drawCircleMap(p, u->getType().airWeapon().maxRange() + (int)(u->getType().airWeapon().maxRange() > 0) * 96 + (int)(u->getType().airWeapon().maxRange() > 192) * 32, Colors::Red);
		tsky.push_back(E);
	}
	pascaL.enemy_sky = tsky;
}

bool Pascal::isInRange(Unit u){
	if (u->isFlying()){
		for (auto& E : enemy_sky){
			Unit e = get<0>(E);
			Position p = get<1>(E);
			if (u->getDistance(p) <= e->getType().airWeapon().maxRange() + (int)(e->getType().airWeapon().maxRange() > 0) * 96 + (int)(e->getType().airWeapon().maxRange() > 192) * 32){
				targetedFrom[u] = p;
				if (IsBuilding(u)){
					if (e->isFlying())
						eSPosition.push_back(e->getPosition());
					else
						eGPosition.push_back(e->getPosition());
				}
				return true;
			}
		}
	}
	else{
		for (const auto& E : enemy_ground){
			Unit e = get<0>(E);
			if (e->getType().isWorker()) continue;
			Position p = get<1>(E);
			if (u->getDistance(p) <= e->getType().groundWeapon().maxRange() + (int)(e->getType().groundWeapon().maxRange() > 0) * 96 + (int)(e->getType().groundWeapon().maxRange() > 192) * 32){
				targetedFrom[u] = p;
				if (IsBuilding(u)){
					if (e->isFlying())
						eSPosition.push_back(e->getPosition());
					else
						eGPosition.push_back(e->getPosition());
				}
				return true;
			}
		}
	}
	return false;
}

bool SquadManager::Defense(){
	bool res = false;
	pascaL.eGPosition.clear();
	pascaL.eSPosition.clear();
	pascaL.targetedFrom.clear();
	for (auto& b : pascaL.building){
		if (pascaL.isInRange(b)){
			res = true;
		}
	}
	return res;
}