#pragma once
#include <BWAPI.h>
#include <iostream>

using namespace BWAPI;
using namespace std;

struct UnitInfo{
	enum Drone { Irrelative, Relative, Default };
	int drone;
	int drone_number;
	/* Irrelative: absolute #drones */
	/* Relative: drone production relative to hatcheriese (drones per hatchery) */
	/* Default (Maximum: Minerals * 1.5) */

	map<UnitType, int> units;
	/* Unit: Num(0: Default, otherwise: specific) */
	/* Produces specifics first, if impossible produces defaults */
	UnitInfo(){}
	UnitInfo(const UnitInfo& UI) :drone(UI.drone), drone_number(UI.drone_number), units(UI.units){}

	bool operator != (UnitInfo b){
		if (this->drone != b.drone) return true;
		if (this->drone == UnitInfo::Drone::Irrelative && this->drone_number != b.drone_number) return true;
		if (this->units.size() != b.units.size()) return true;
		for (auto& u : this->units){
			if (b.units.find(u.first) == b.units.end()) return true;
			if (b.units[u.first] != u.second) return true;
		}
		return false;
	}
};

struct BuildInfo{
	enum Hatchery { Expand, Extra, Limited };
	int hatchery;
	/* Expand: allows expand, and extra hatcheries */
	/* Extra: allows extra hatcheries only */
	/* Limited: allows no more hatchery */

	map<UnitType, int> buildings;
	BuildInfo(){}
	BuildInfo(const BuildInfo& BI) : hatchery(BI.hatchery), buildings(BI.buildings) {}

	bool operator != (BuildInfo b){
		if (this->hatchery != b.hatchery) return true;
		if (this->buildings.size() != b.buildings.size()) return true;
		for (auto& u : this->buildings){
			if (b.buildings.find(u.first) == b.buildings.end()) return true;
			if (b.buildings[u.first] != u.second) return true;
		}
		return false;
	}
};

struct UpgradeInfo{
	map<UpgradeType, int> upgrades;
	vector<TechType> techs;
	UpgradeInfo(){}
	UpgradeInfo(const UpgradeInfo& UI) : upgrades(UI.upgrades), techs(UI.techs){}

	bool operator != (UpgradeInfo b){
		if (this->upgrades.size() != b.upgrades.size()) return true;
		for (auto& u : this->upgrades){
			if (b.upgrades.find(u.first) == b.upgrades.end()) return true;
			if (b.upgrades[u.first] != u.second) return true;
		}
		return false;
	}
};

struct Resource{
	int mineral, gas, larva;
	int uMineral, uGas;
	Resource(int m, int g, int l, int um, int ug) : mineral(m), gas(g), larva(l), uMineral(um), uGas(ug) {}
};