#include "PlayManager.h"
#include <iostream>
#include <BWAPI.h>
#include <string>

using namespace BWAPI;
using namespace Filter;

tuple<BuildInfo, UnitInfo, UpgradeInfo, UpgradeInfo> PlayManager::Play(vector<Unit> All, bool detect){
	Broodwar->drawTextScreen(0, 0, "Strategy: %s", memory.strat);

	BuildInfo neoB;
	UnitInfo neoU;
	UpgradeInfo neoUP, upgrading;

	if (memory.data == NULL){
		Broodwar << "ERROR : Memory in PlayManager" << endl;
		return make_tuple(neoB, neoU, neoUP, upgrading);
	}

	neoU = memory.data->unit;
	neoB = memory.data->build;
	neoUP = memory.data->upgrade;

	if (detect) neoUP.upgrades[UpgradeTypes::Pneumatized_Carapace] = 1;

	Built.clear();
	for (auto& u : All){
		if (IsBuilding(u) && IsCompleted(u)){
			if (find(Built.begin(), Built.end(), u->getType()) == Built.end()){
				Built.push_back(u->getType());
			}
		}
	}

	int i = 15;
	bool refresh = true;
	while (refresh){
		BuildInfo tB(neoB);
		UnitInfo tU(neoU);
		UpgradeInfo tUP(neoUP);
		refresh = false;

		for (auto& u : tU.units){
			map<UnitType, int> tMap = u.first.requiredUnits();
			for (const auto& uu : tMap){
				if (uu.first == UnitTypes::None) continue;
				if (uu.first == UnitTypes::Zerg_Larva) continue;
				if (uu.first.isBuilding()){
					if (uu.first != UnitTypes::Zerg_Hatchery){
						if (tB.buildings.find(uu.first) == tB.buildings.end()){
							tB.buildings[uu.first] = uu.second;
							refresh = true;
							break;
						}
					}
				}
				else{
					if (tU.units.find(uu.first) == tU.units.end()){
						tU.units[uu.first] = uu.second;
						refresh = true;
						break;
					}
				}
			}
			TechType TT = u.first.requiredTech();
			if (TT == TechTypes::None) continue;
			if (find(tUP.techs.begin(), tUP.techs.end(), TT) == tUP.techs.end()){
				tUP.techs.push_back(TT);
				refresh = true;
				break;
			}
		}
		if (refresh){
			neoU = tU;
			neoB = tB;
			neoUP = tUP;
			continue;
		}
		for (auto& u : tUP.upgrades){
			UnitType UT = u.first.whatUpgrades();
			if (UT != UnitTypes::None && UT != UnitTypes::Zerg_Hatchery){
				if (tB.buildings.find(UT) == tB.buildings.end()){
					tB.buildings[UT] = 1;
					refresh = true;
					break;
				}
			}
			UnitType UT2 = u.first.whatsRequired();
			if (UT2 != UnitTypes::None && UT2 != UnitTypes::Zerg_Hatchery){
				if (tB.buildings.find(UT2) == tB.buildings.end()){
					tB.buildings[UT2] = 1;
					refresh = true;
					break;
				}
			}
		}
		if (refresh){
			neoU = tU;
			neoB = tB;
			neoUP = tUP;
			continue;
		}
		for (auto& u : tUP.techs){
			UnitType UT = u.whatResearches();
			if (UT != UnitTypes::None && UT != UnitTypes::Zerg_Hatchery){
				if (tB.buildings.find(UT) == tB.buildings.end()){
					tB.buildings[UT] = 1;
					refresh = true;
					break;
				}
			}
			UnitType UT2 = u.requiredUnit();
			if (UT2 != UnitTypes::None && UT2 != UnitTypes::Zerg_Hatchery){
				if (tB.buildings.find(UT2) == tB.buildings.end()){
					tB.buildings[UT2] = 1;
					refresh = true;
					break;
				}
			}
		}
		if (refresh){
			neoU = tU;
			neoB = tB;
			neoUP = tUP;
			continue;
		}
		for (auto& u : tB.buildings){
			map<UnitType, int> tMap = u.first.requiredUnits();
			for (const auto& uu : tMap){
				if (uu.first == UnitTypes::None) continue;
				if (uu.first.isBuilding() && uu.first != UnitTypes::Zerg_Hatchery){
					if (tB.buildings.find(uu.first) == tB.buildings.end()){
						tB.buildings[uu.first] = uu.second;
						refresh = true;
						break;
					}
				}
			}
		}
		neoU = tU;
		neoB = tB;
		neoUP = tUP;
	}

	for (auto& u : neoUP.upgrades){
		UnitType UT;
		if (u.first == UpgradeTypes::Pneumatized_Carapace) UT = UnitTypes::Zerg_Lair;
		else UT = u.first.whatUpgrades();
		vector<Unit> tBuilding;
		for (auto& b : building){
			if (!b) continue;
			if (!b->exists()) continue;
			if (b->canUpgrade(u.first) && Broodwar->self()->getUpgradeLevel(u.first) < u.second){
				b->upgrade(u.first);
			}
			tBuilding.push_back(b);
		}
		building = tBuilding;
	}

	for (auto& u : neoUP.techs){
		UnitType UT = u.whatResearches();
		vector<Unit> tBuilding;
		for (auto& b : building){
			if (!b) continue;
			if (!b->exists()) continue;
			if (b->canUpgrade(u) && !Broodwar->self()->hasResearched(u)){
				b->research(u);
			}
			tBuilding.push_back(b);
		}
		building = tBuilding;
	}

	for (auto& b : building){
		if (!b) continue;
		if (!b->exists()) continue;
		if (b->isUpgrading())
			upgrading.upgrades[b->getUpgrade()] = Broodwar->self()->getUpgradeLevel(b->getUpgrade()) + 1;
		if (b->isResearching())
			upgrading.techs.push_back(b->getTech());
	}

	return make_tuple(neoB, neoU, neoUP, upgrading);
}

bool PlayManager::canIt(UpgradeType UT, int level){
	UnitType ut = UT.whatsRequired(level);
	UnitType ut2 = UT.whatUpgrades();
	bool flag1 = false, flag2 = false;
	for (auto& u : Built){
		if (u == ut || ut == UnitTypes::None) flag1 = true;
		if (u == ut2 || ut2 == UnitTypes::None) flag2 = true;
	}
	return flag1 && flag2;
}

bool PlayManager::canIt(TechType TT){
	UnitType ut = TT.requiredUnit();
	UnitType ut2 = TT.whatResearches();
	bool flag1 = false, flag2 = false;
	for (auto& u : Built){
		if (u == ut || ut == UnitTypes::None) flag1 = true;
		if (u == ut2 || ut2 == UnitTypes::None) flag2 = true;
	}
	return flag1 && flag2;
}