#pragma once
#include <iostream>
#include <vector>
#include <queue>
#include <BWAPI.h>
#include "ProductInfo.h"

using namespace std;
using namespace BWAPI;

struct Zia{
	unsigned n;
	unsigned win, lose;
	vector<Zia> zia;
	Zia() :n(0), win(0), lose(0){};
	Zia(const Zia& z) :n(z.n), win(0), lose(0), zia(z.zia){}
};

struct Data{
	bool rush;
	Data* next; // next Data
	UnitInfo unit;
	BuildInfo build;
	UpgradeInfo upgrade;
	Data() :rush(false){};
	Data(bool r, UnitInfo UI, BuildInfo BI, UpgradeInfo UpI) : rush(r), unit(UI), build(BI), upgrade(UpI), next(NULL){}

	bool operator== (Data b){
		if (this->rush != b.rush) return false;
		if (this->unit != b.unit) return false;
		if (this->build != b.build) return false;
		if (this->upgrade != b.upgrade) return false;
		return true;
	}
};

class Memory{
public:
	char* strat;
	Zia zia; // total data pool
	Zia race;
	Zia enemy;
	queue<int> strategy; // choosen strategy
	queue<int> strategy_store;
	Data* data; // strategy data
	void read();
	void write(bool);
	void next();

	//queue<int> next_strategy(Zia&);
	bool finish(queue<int>);
};