#include "Memory.h"
#include "ProductInfo.h"
#include <iostream>
#include <fstream>
#include <string>
#include <queue>
#include <BWAPI.h>
#include <time.h>

using namespace std;
using namespace BWAPI;

Data new_Data(){
	Data data;
	data.rush = (bool)rand() % 2;
	data.unit.drone = (rand() % 2) * 2;
	data.unit.drone_number = rand() % 20 + 4;
	int temp;
	// zergling
	temp = rand() % 14;
	if (temp > 0){
		data.unit.units[UnitTypes::Zerg_Zergling] = temp - 1;
		temp = rand() % 2;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Metabolic_Boost] = temp;
		temp = rand() % 2;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Adrenal_Glands] = temp;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Melee_Attacks] = temp;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Carapace] = temp;
	}
	// hydra
	temp = rand() % 14;
	if (temp > 0){
		data.unit.units[UnitTypes::Zerg_Hydralisk] = temp - 1;
		temp = rand() % 2;
		if (temp > 0) data.upgrade.upgrades[(UpgradeType)29] = temp; // ߾
		temp = rand() % 2;
		if (temp > 0) data.upgrade.upgrades[(UpgradeType)30] = temp; // 
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Missile_Attacks] = temp;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Carapace] = temp;
	}
	// Mutal
	temp = rand() % 14;
	if (temp > 0){
		data.unit.units[UnitTypes::Zerg_Mutalisk] = temp - 1;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Flyer_Attacks] = temp;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Flyer_Carapace] = temp;
	}
	// Lurker
	temp = rand() % 14;
	if (temp > 0){
		data.unit.units[UnitTypes::Zerg_Lurker] = temp - 1;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Missile_Attacks] = temp;
		temp = rand() % 4;
		if (temp > 0) data.upgrade.upgrades[UpgradeTypes::Zerg_Carapace] = temp;
	}
	return data;
}

Data file_to_data(ifstream& input){
	Data res;
	bool rush;
	int a, b;
	// input UI
	UnitInfo UI;
	input >> a;
	res.rush = a;
	input >> a >> b;
	UI.drone = a;
	UI.drone_number = b;
	input >> a;
	while (a != -1){
		input >> b;
		UI.units[(UnitType)a] = b;
		input >> a;
	}
	// input BI
	BuildInfo BI;
	input >> a;
	BI.hatchery = a;
	input >> a;
	while (a != -1){
		input >> b;
		BI.buildings[(UnitType)a] = b;
		input >> a;
	}
	// input UpI
	UpgradeInfo UpI;
	input >> a;
	while (a != -1){
		input >> b;
		UpI.upgrades[(UpgradeType)a] = b;
		input >> a;
	}
	input >> a;
	while (a != -1){
		UpI.techs.push_back((TechType)a);
		input >> a;
	}
	res.unit = UI;
	res.build = BI;
	res.upgrade = UpI;
	return res;
}

void data_to_file(ofstream& output, Data& data){
	output << data.rush << " " << data.unit.drone << " " << data.unit.drone_number<<endl;
	for (auto& u : data.unit.units){
		output << (int)u.first << " " << u.second << endl;
	}
	output << "-1" << endl << data.build.hatchery << endl;
	for (auto& u : data.build.buildings){
		output << (int)u.first << " " << u.second << endl;
	} output << "-1" << endl;
	for (auto& u : data.upgrade.upgrades){
		output << (int)u.first << " " << u.second << endl;
	} output << "-1" << endl;
	for (auto& u : data.upgrade.techs){
		output << (int)u << endl;
	} output << "-1" << endl;
}

void zia_read(ifstream& input, Zia& zia){
	unsigned n; input >> n;
	zia.n = n;
	for (unsigned i = 1; i <= n; i++){
		Zia son;
		zia_read(input, son);
		zia.zia.push_back(son);
	}
}

void enemy_read(ifstream& input, Zia& enemy){
	unsigned n, a, b; input >> n >> a >> b;
	enemy.n = n; enemy.win = a; enemy.lose = b;
	for (unsigned i = 1; i <= n; i++){
		Zia son;
		enemy_read(input, son);
		enemy.zia.push_back(son);
	}
}

void zia_write(ofstream& output, Zia& zia, int tab){
	for (int i = 0; i < tab; i++) output << "	";
	output << zia.n << " " << zia.win << " " << zia.lose << endl;
	for (int i = 0; i < zia.zia.size(); i++){
		zia_write(output, zia.zia.at(i), tab + 1);
	}
}

void zia_end(queue<int> strategy, Zia& zia, bool win){
	if (win) zia.win++;
	else zia.lose++;
	if (strategy.empty()) return;
	int temp = strategy.front();
	strategy.pop();
	zia_end(strategy, zia.zia.at(temp - 1), win);
}

bool Memory::finish(queue<int> strategy){
	ifstream input;
	string name;
	//Load strategy data
	name = "bwapi-data/zia/Strategies/The";
	bool rFlag, dFlag;
	while (!strategy.empty()){
		int t = strategy.front();
		string str = std::to_string(t);
		name.append("_" + str);
		strategy.pop();
		if (strategy.empty()){
			// input setting
			str = name + ".txt";
			input = ifstream(str);
			if (!input.is_open()){
				Broodwar << "ERROR : No " << str << " File Found" << endl;
				return false;
			}
			bool rush;
			int a, b;
			// input UI
			UnitInfo UI;
			input >> rFlag;
			input >> a >> b;
			UI.drone = a;
			UI.drone_number = b;
			input >> a;
			while (a != -1){
				input >> b;
				if (b == 0){
					dFlag = true;
					break;
				}
				UI.units[(UnitType)a] = b;
				input >> a;
			}
		}
	}
	if (dFlag && rFlag) return true;
	return false;
}

bool overlap(queue<int> strategy, Data data){
	ifstream input;
	string name;
	//Load strategy data
	name = "bwapi-data/zia/Strategies/The";
	while (!strategy.empty()){
		int t = strategy.front();
		string str = std::to_string(t);
		name.append("_" + str);
		strategy.pop();
		if (strategy.empty()){
			int i = 1;
			while (true){
				string s = name + "_" + to_string(i) + ".txt";
				ifstream input(s);
				if (input){
					if (data == file_to_data(input)) return true;
					i++;
				}
				else break;
			}
			string s = name + "_" + to_string(i) + ".txt";
			ofstream output(s);
			data_to_file(output, data);
			return false;
		}
	}
}

queue<int> next_strategy(Zia& zia){
	queue<int> res;
	if (zia.n == 0) return res;
	int checked = 0;
	int index = 0;
	double highest = 0;
	for (int i = 0; i < zia.n; i++){
		double temp = zia.zia.at(i).win + zia.zia.at(i).lose;
		if (temp == 0) continue;
		checked++;
		temp = zia.zia.at(i).win / temp;
		if (temp < 0.50) continue;
		if (temp > highest){
			index = i + 1;
			highest = temp;
		}
	}
	if (index == 0){
		if (checked < zia.n){
			for (int i = 0; i < zia.n; i++){
				double temp = zia.zia.at(i).win + zia.zia.at(i).lose;
				if (temp == 0){
					index = i + 1;
					break;
				}
			}
		}
		else{
			index = rand() % zia.n + 1;
		}
	}
	res.push(index);
	queue<int> tres = next_strategy(zia.zia.at(index - 1));
	while (!tres.empty()){
		res.push(tres.front());
		tres.pop();
	}
	return res;
}

queue<int> Trace(Zia& zia){
	queue<int> res;
	double highest = 0;
	int n = 0;
	int i = 1;
	vector<Zia>::iterator ZI;
	vector<Zia>::iterator zRes;
	for (ZI = zia.zia.begin(); ZI != zia.zia.end(); ++ZI){
		if (ZI->win + ZI->lose == 0){
			i++;
			continue;
		}
		double temp = ZI->win / (ZI->win + ZI->lose);
		if (highest == 0){
			highest = temp;
			n = i;
			zRes = ZI;
		}
		else if (highest < temp){
			highest = temp;
			n = i;
			zRes = ZI;
		}
		i++;
	}
	res.push(n); Broodwar << n << endl;
	if (n != 0){
		queue<int> tres = Trace(*zRes);
		while (!tres.empty()){
			res.push(tres.front());
			tres.pop();
		}
	}
	return res;
}

void Update(Zia& main, Zia& sub){
	if (main.n == 0) return;
	if (main.zia.size() != sub.zia.size()) sub.n = main.n;
	int _i = sub.zia.size();
	int size = main.zia.size();
	for (int i = 0; i < _i; i++){
		Update(main.zia.at(i), sub.zia.at(i));
	}
	for (; _i < size; _i++){
		Zia neo(main.zia.at(_i));
		sub.zia.push_back(neo);
	}
}

void Memory::read(){
	string name;

	//Load main data
	ifstream input("bwapi-data/AI/Thebot/Thebot.txt");

	if (!input.is_open()){
		Broodwar << "ERROR : No Zia File Found" << endl;
		return;
	}

	unsigned n, a, b; input >> n;
	zia.n = n;
	for (unsigned i = 1; i <= n; i++){
		Zia son;
		zia_read(input, son);
		zia.zia.push_back(son);
	}

	//Load enemy data
	name = "bwapi-data/read/Enemy/";
	name.append(Broodwar->enemy()->getName().c_str());
	name.append(".txt");
	input.close();
	input = ifstream(name);

	//Select strategy
	if (!input.is_open()){
		Broodwar << "Warning : No Enemy File Found" << endl;
		enemy = zia;
		strat = "2";
		strategy.push(2);
		strategy.push(1);
		strategy.push(1);
		strategy_store = strategy;
	}
	else{
		// Load default set in previous game
		int s; input >> s;
		while (s != -1){
			strategy.push(s);
			input >> s;
		}

		if (strategy.empty()){
			Broodwar << "Warning : No Enemy File Found" << endl;
			enemy = zia;
			strategy = next_strategy(enemy);
			if (strategy.empty()){
				strat = "1";
				strategy.push(1);
				strategy.push(1);
				strategy_store = strategy;
			}
			else{
				string str = to_string(strategy.front());
				strat = new char[str.length() + 1];
				strcpy(strat, str.c_str());
			}
		}
		else{
			unsigned n, a, b; input >> n >> a >> b;
			enemy.n = n; enemy.win = a; enemy.lose = b;
			for (unsigned i = 1; i <= n; i++){
				Zia son;
				enemy_read(input, son);
				enemy.zia.push_back(son);
			}

			string str = to_string(strategy.front());
			strat = new char[str.length() + 1];
			strcpy(strat, str.c_str());
		}
	}

	//Load strategy data
	name = "bwapi-data/AI/Thebot/Strategies/The";
	Data** present = &data;
	while (!strategy.empty()){
		int t = strategy.front();
		strategy.pop();
		// input setting
		string str = std::to_string(t);
		name.append("_" + str);
		input.close();
		str = name + ".txt";
		input = ifstream(str);

		if (!input.is_open()){
			Broodwar << "ERROR : No " << str << " File Found" << endl;
			return;
		}
		bool rush;
		int a, b;
		// input UI
		UnitInfo UI;
		input >> a;
		rush = a;
		input >> a >> b;
		UI.drone = a;
		UI.drone_number = b;
		input >> a;
		while (a != -1){
			input >> b;
			UI.units[(UnitType)a] = b;
			input >> a;
		}
		// input BI
		BuildInfo BI;
		input >> a;
		BI.hatchery = a;
		input >> a;
		while (a != -1){
			input >> b;
			BI.buildings[(UnitType)a] = b;
			input >> a;
		}
		// input UpI
		UpgradeInfo UpI;
		input >> a;
		while (a != -1){
			input >> b;
			UpI.upgrades[(UpgradeType)a] = b;
			input >> a;
		}
		input >> a;
		while (a != -1){
			UpI.techs.push_back((TechType)a);
			input >> a;
		}
		*present = new Data(rush, UI, BI, UpI);
		present = &(*present)->next;
	}
	input.close();
}

void Memory::write(bool win){
	srand(time(NULL));

	zia_end(strategy_store, enemy, win);
	// Enemy
	// Race
	// Main

	// Enemy
	string name;
	name = "bwapi-data/write/Enemy/";
	name.append(Broodwar->enemy()->getName().c_str());
	name.append(".txt");

	ofstream output(name);
		// Next Strategy
	queue<int> store = strategy_store;
	if (win){
		while (!strategy_store.empty()){
			output << strategy_store.front() << " ";
			strategy_store.pop();
		} output << "-1" << endl;
	}
	else{
		strategy = next_strategy(enemy);
		while (!strategy.empty()){
			output << strategy.front() << " ";
			strategy.pop();
		} output << "-1" << endl;
	}
	zia_write(output, enemy, 0);
}

void Memory::next(){
	if (data->next != NULL){
		strategy.pop();
		string str = (string)strat + "_" + std::to_string(strategy.front());
		strat = new char[str.length() + 1];
		strcpy(strat, str.c_str());
		data = data->next;
	}
}