#pragma once
#include <BWAPI.h>
#include <iostream>
#include "BuildLocation.h"
#include "Worker.h"
#include "Hatchery.h"
#include "PlayManager.h"
#include "Squad.h"

using namespace BWAPI;
using namespace std;

class Manager{
public:
	/* Data Bus */
	bool detect;
	bool hatch;
	UpgradeInfo upgrading;
	vector<Unit> geysers;
	bool _gas; // Whether gas used
	int _i; // i for print

	/* reserved resources */
	int mineral;
	int gas;
	int larva;
	/* reserved resources for Unit */
	int uMineral;
	int uGas;

	map<UnitType, int> N_unit;
	vector<Unit> All_units;

	BuildLocations buildlocations;
	PlayManager playmanager;
	Hatchery hatchery;
	Worker worker;
	SquadManager squadmanager;

public:
	Manager() : mineral(0), gas(0), detect(false), hatch(false){}
	void start();
	void refresh(bool debug);
	void push(Unit);
	void push(TilePosition);
	void push(tuple<Unit, Position>); // Enemy Buildings
	void pop(Unit);
	void ResourceManager(tuple<BuildInfo, UnitInfo, UpgradeInfo, UpgradeInfo>);
	void MorphManager(BuildInfo, UnitInfo);
	bool hasIt(UnitType); // Finding Completed UT
	int hasUnit(UnitType); // Figures the number of UT including those getting produced

	void end(bool Win){ playmanager.write(Win);}
};