#include "Manager.h"
#include "Worker.h"
#include "Hatchery.h"
#include <iostream>
#include <BWAPI.h>

using namespace BWAPI;
using namespace Filter;
using namespace std;

void Manager::refresh(bool debug){
	/* Data Initial Setting */
	N_unit.clear();
	N_unit = Hatchery::getN(All_units);

	tuple<BuildInfo, UnitInfo, UpgradeInfo, UpgradeInfo> tData = playmanager.Play(All_units, detect);
	ResourceManager(tData);

	// Printing Data
	Broodwar->drawTextScreen(430, 20, "Reserved Larva: %d / %d", larva, N_unit[UnitTypes::Zerg_Larva]);
	Broodwar->drawTextScreen(430, 35, "Reserved Mineral: %d", mineral);
	Broodwar->drawTextScreen(430, 50, "Reserved Gas: %d", gas);
	Resource reserved(mineral, gas, N_unit[UnitTypes::Zerg_Larva] - larva, uMineral, uGas);

	//Refresh   (PlayManager) -> Hatchery -> BuildLocation -> Worker -> SquadManager
	hatchery.setMORE(get<0>(tData).hatchery);
	tuple<UpgradeInfo, tuple<Unit, TilePosition>> tH = hatchery.refresh(_gas, get<1>(tData), All_units, reserved, buildlocations, N_unit[UnitTypes::Zerg_Overlord]);
	upgrading = get<0>(tH);
	geysers = hatchery.getGeysers();
	buildlocations.Update(hatchery.RandomHatchery());
	hatch = worker.refresh(All_units, hatchery.MLHatchery(), hatchery.unsatisfied(), buildlocations, get<0>(tData), get<1>(tH), geysers);
	squadmanager.cycle(playmanager.rush(), buildlocations, N_unit);

	MorphManager(get<0>(tData), get<1>(tData));
}

void Manager::ResourceManager(tuple<BuildInfo, UnitInfo, UpgradeInfo, UpgradeInfo> Data){
	// Reserving Larva, Minerals, and Gas
	gas = larva = 0;
	uMineral = mineral = 300 * (int)hatch;
	_i = 30;
	bool next = true;
	BuildInfo BI;
	UnitInfo UI;
	UpgradeInfo UpI;
	tie(BI, UI, UpI, upgrading) = Data;
	switch (UI.drone){
	case 0: // Irrelative
		Broodwar->drawTextScreen(0, 15, "%s: %d / %d", UnitTypes::Zerg_Drone.c_str(), N_unit[UnitTypes::Zerg_Drone], UI.drone_number);
		break;
	case 1: // Relative
		Broodwar->drawTextScreen(0, 15, "%s: %d / %d", UnitTypes::Zerg_Drone.c_str(), N_unit[UnitTypes::Zerg_Drone], UI.drone_number * hatchery.MLHatchery().size());
		break;
	default: // Default
		Broodwar->drawTextScreen(0, 15, "%s: %d / %d", UnitTypes::Zerg_Drone.c_str(), N_unit[UnitTypes::Zerg_Drone], hatchery.MLHatchery().size() * 1.5);
		break;
	}
	// Units
	for (auto& u : UI.units){
		if (next){
			if (N_unit[u.first] < u.second) next = false;
		}
		Broodwar->drawTextScreen(0, _i, "%s: %d / %d", u.first.c_str(), N_unit[u.first], u.second);
		_i += 15;
		if (u.first.gasPrice() > 0) _gas = true;
		if (u.second == 0) continue;
		bool flag = true;
		for (const auto& R : u.first.requiredUnits()){
			if (!hasIt(R.first)){
				flag = false;
				break;
			}
		}
		if (!flag) continue;
		if (u.second <= hasUnit(u.first)) continue;
		uMineral += u.first.mineralPrice() * (u.second - hasUnit(u.first));
		uGas += u.first.gasPrice() * (u.second - hasUnit(u.first));
		mineral += u.first.mineralPrice() * (u.second - hasUnit(u.first));
		gas += u.first.gasPrice() * (u.second - hasUnit(u.first));
		larva += u.second / ( 1 + (u.first.isTwoUnitsInOneEgg())) - hasUnit(u.first);
	}

	// Buildings
	for (auto& u : BI.buildings){
		if (next){
			if (N_unit[u.first] < u.second) next = false;
		}
		if (u.first.gasPrice() > 0) _gas = true;
		if (u.second == 0) continue;
		bool flag = true;
		for (const auto& R : u.first.requiredUnits()){
			if (!hasIt(R.first)){
				flag = false;
				break;
			}
		}
		if (!flag) continue;
		if (u.second <= hasUnit(u.first)) continue;
		uMineral += u.first.mineralPrice() * (u.second - hasUnit(u.first));
		uGas += u.first.gasPrice() * (u.second - hasUnit(u.first));
		mineral += u.first.mineralPrice() * (u.second - hasUnit(u.first));
		gas += u.first.gasPrice() * (u.second - hasUnit(u.first));
		larva += u.second / (1 + (u.first.isTwoUnitsInOneEgg())) - hasUnit(u.first);
	}

	// Upgrades
	for (auto& U : UpI.upgrades){
		UnitType UT = U.first.whatUpgrades();
		UnitType UT2 = U.first.whatsRequired(U.second);
		if (Broodwar->self()->getUpgradeLevel(U.first) < U.second){
			Broodwar->drawTextScreen(0, _i, "%s", U.first.c_str());
			_i += 15;
			if (hasIt(UT) && hasIt(UT2)){
				mineral += U.first.mineralPrice() + U.first.mineralPriceFactor() * (U.second - 1);
				gas += U.first.gasPrice() + U.first.gasPriceFactor() * (U.second - 1);
				_gas = true;
			}
			if(U.first != UpgradeTypes::Pneumatized_Carapace) next = false;
		}
	}
	// Techs
	for (auto& T : UpI.techs){
		UnitType UT = T.whatResearches();
		if (!Broodwar->self()->hasResearched(T)){
			Broodwar->drawTextScreen(0, _i, "%s", T.c_str());
			_i += 15;
			if (hasIt(UT)){ // && hasIt(UT2)){
				_gas = true;
				mineral += T.mineralPrice();
				gas += T.gasPrice();
			}
			next = false;
		}
	}
	// Deducting Upgradings
	for (auto& U : upgrading.upgrades){
		mineral -= U.first.mineralPrice() + U.first.mineralPriceFactor() * (U.second - 1);
		gas -= U.first.gasPrice() + U.first.gasPriceFactor() * (U.second - 1);
	}
	for (const auto& T : upgrading.techs){
		mineral -= T.mineralPrice();
		gas -= T.gasPrice();
	}
	// Buildings
	for (auto& b : BI.buildings){
		if (N_unit[b.first] < b.second || b.first == UnitTypes::Zerg_Hatchery){
			Broodwar->drawTextScreen(0, _i, "%s: %d / %d", b.first.c_str(), N_unit[b.first], b.second);
			_i += 15;
			if (b.first != UnitTypes::Zerg_Hatchery) next = false;
		}
		bool flag = true;
		for (const auto& B : b.first.requiredUnits()){
			if (!hasIt(B.first)){
				flag = false;
				break;
			}
		}
		if (!flag) continue;
		if (b.second <= hasUnit(b.first)) continue;
		mineral += b.first.mineralPrice();
		gas += b.first.gasPrice();
	}
	if (next) playmanager.next();
}

void Manager::MorphManager(BuildInfo BI, UnitInfo UI){
	bool Hive = false;
	bool Lair = false;
	bool Greater = false;
	int lurker = 0;
	int guardian = 0;
	int devourer = 0;
	for (auto& u : BI.buildings){
		if (u.first == UnitTypes::Zerg_Hive && N_unit[u.first] == 0) Hive = true;
		else if (u.first == UnitTypes::Zerg_Lair && N_unit[u.first] == 0) Lair = true;
		else if (u.first == UnitTypes::Zerg_Greater_Spire && N_unit[u.first] == 0) Greater = true;
	}
	for (auto& u : UI.units){
		if (u.first == UnitTypes::Zerg_Lurker){
			if (u.second == 0)
				lurker = -1;
			else
				lurker = u.second - N_unit[u.first];
		}
		else if (u.first == UnitTypes::Zerg_Guardian){
			if (u.second == 0)
				guardian = -1;
			else
				guardian = u.second - N_unit[u.first];
		}
		else if (u.first == UnitTypes::Zerg_Devourer){
			if (u.second == 0)
				devourer = -1;
			else
				devourer = u.second - N_unit[u.first];
		}
	}
	for (auto& u : All_units){
		if (Hive){
			if (u->getType() == UnitTypes::Zerg_Lair){
				if (u->canMorph(UnitTypes::Zerg_Hive)){
					u->morph(UnitTypes::Zerg_Hive);
					Hive = false;
				}
			}
		}
		if (Lair){
			if (u->getType() == UnitTypes::Zerg_Hatchery){
				if (u->canMorph(UnitTypes::Zerg_Lair)){
					u->morph(UnitTypes::Zerg_Lair);
					Lair = false;
				}
			}
		}
		if (Greater){
			if (u->getType() == UnitTypes::Zerg_Spire){
				if (u->canMorph(UnitTypes::Zerg_Greater_Spire)){
					u->morph(UnitTypes::Zerg_Greater_Spire);
					Greater = false;
				}
			}
		}
		if (u->getType() == UnitTypes::Zerg_Hydralisk){
			if (lurker < 0){
				if (u->canMorph(UnitTypes::Zerg_Lurker)){
					u->morph(UnitTypes::Zerg_Lurker);
				}
			}
			else if (lurker > 0){
				if (u->canMorph(UnitTypes::Zerg_Lurker)){
					u->morph(UnitTypes::Zerg_Lurker);
					lurker--;
				}
			}
		}
		if (u->getType() == UnitTypes::Zerg_Hydralisk && lurker != 0){
			if (lurker < 0){
				if (u->canMorph(UnitTypes::Zerg_Lurker)){
					u->morph(UnitTypes::Zerg_Lurker);
				}
			}
			else if (lurker > 0){
				if (u->canMorph(UnitTypes::Zerg_Lurker)){
					u->morph(UnitTypes::Zerg_Lurker);
					lurker--;
				}
			}
		}
		if (u->getType() == UnitTypes::Zerg_Mutalisk && (devourer != 0 || guardian != 0)){
			if ((guardian && devourer && Broodwar->getFrameCount() % 2 == 0) || guardian != 0){
				if (guardian < 0){
					if (u->canMorph(UnitTypes::Zerg_Guardian)){
						u->morph(UnitTypes::Zerg_Guardian);
					}
				}
				else if (guardian > 0){
					if (u->canMorph(UnitTypes::Zerg_Guardian)){
						u->morph(UnitTypes::Zerg_Guardian);
						guardian--;
					}
				}
			}
			else{
				if (devourer < 0){
					if (u->canMorph(UnitTypes::Zerg_Devourer)){
						u->morph(UnitTypes::Zerg_Devourer);
					}
				}
				else if (devourer > 0){
					if (u->canMorph(UnitTypes::Zerg_Devourer)){
						u->morph(UnitTypes::Zerg_Devourer);
						devourer--;
					}
				}
			}
		}
	}
}

void Manager::start()
{
	playmanager.memory.read();
}

void Manager::push(Unit u){
	if (IsEnemy(u)){
		squadmanager.push(u);
		if (u->isCloaked() || u->canCloak() || u->isBurrowed() || u->getType() == UnitTypes::Zerg_Lurker ||
			u->getType() ==UnitTypes::Zerg_Lurker_Egg) detect = true;
	}
	if (IsOwned(u)){
		if (u->getType().isWorker()) // Worker
			worker.push(u);
		else if (u->getType().isResourceDepot() && IsBuilding(u)){ // Hatcheries
			hatchery.push(u, buildlocations.isML(u->getTilePosition()));
			playmanager.push(u);
		}
		else{
			squadmanager.push(u);
			if (IsBuilding(u))
				playmanager.push(u);
		}

		if (std::find(All_units.begin(), All_units.end(), u) == All_units.end()){
			All_units.push_back(u);
		}
	}
}

void Manager::push(TilePosition TP)
{buildlocations.push(TP);}

void Manager::push(tuple<Unit, Position> UP)
{squadmanager.push(UP);}

void Manager::pop(Unit u){
	if (IsEnemy(u)) squadmanager.pop(u);
	if (IsOwned(u)){
		if (u->getType().isWorker())
			worker.pop(u);
		else if (u->getType().isResourceDepot() && IsBuilding(u))
			hatchery.pop(u);
		else
			squadmanager.pop(u);

		vector<Unit> tAll;
		for (const auto& U : All_units){
			if (U == u) continue;
			tAll.push_back(U);
		}
		All_units = tAll;
		N_unit[u->getType()]--;
	}
	if (IsEnemy(u)){
		squadmanager.pop(u);
	}
}

bool Manager::hasIt(UnitType UT){
	if (UT == UnitTypes::None) return true;
	for (const auto& u : All_units){
		if (u->getType() == UT && u->isCompleted()) return true;
	}
	return false;
}

int Manager::hasUnit(UnitType UT){
	int res = 0;
	for (const auto& u : All_units){
		if (u->getType() == UT) res++;
		else if (u->getType() == UnitTypes::Zerg_Egg){
			auto& que = u->getTrainingQueue();
			if (que.size() > 0){
				if (que.front() == UT) res++;
				if (que.front().isTwoUnitsInOneEgg()) res++;
			}
		}
	}
	return res;
}