#pragma once
#include <BWAPI.h>
#include <iostream>
#include "ProductInfo.h"
#include "BuildLocation.h"

using namespace BWAPI;
using namespace std;

struct HatchData{
	bool multi;
	bool satisfied;
	HatchData(){}
	HatchData(bool s) :multi(true), satisfied(s){}
};

class Hatchery{
public:
	int MORE;
	int mineral, gas, larva, uMineral;
	map<Unit, HatchData> hatchery;
	vector<Unit> geysers;
	vector<Unit> All;
public:
	void push(Unit, bool isML);
	void pop(Unit);
	bool ok(Unit, UnitType); // is it okay to morph a larav into
	int hasUnit(UnitType);
	tuple<UpgradeInfo, tuple<Unit, TilePosition>> refresh(bool gas, UnitInfo, vector<Unit> All, Resource, BuildLocations, int);
	Unit RandomHatchery();
	vector<Unit> getGeysers();
	vector<Unit> MLHatchery();
	vector<Unit> unsatisfied();

	void setMORE(int n){ MORE = n; }

	static map<UnitType, int> getN(vector<Unit>, bool cheat = false);
};