#include <iostream>
#include <BWAPI.h>
#include "Hatchery.h"
#include "BuildLocation.h"

using namespace BWAPI;
using namespace Filter;
using namespace std;

vector<tuple<UnitType, int> > sort(UnitInfo UI){
	vector<tuple<UnitType, int> > res;
	//push required first
	for (auto& ui : UI.units){
		if (ui.second > 0)
			res.push_back(make_tuple(ui.first, ui.second));
	}
	//push defaults by decreasing order
	vector<UnitType> UTs;
	while (res.size() < UI.units.size()){
		UnitType UT;
		int gas = -1;
		for (auto& ui : UI.units){
			if (ui.second == 0 && (find(UTs.begin(), UTs.end(), ui.first) == UTs.end())){
				if (ui.first.gasPrice() > gas){
					UT = ui.first;
					gas = ui.first.gasPrice();
				}
			}
		}
		res.push_back(make_tuple(UT, 0));
		UTs.push_back(UT);
	}
	return res;
}

map<UnitType, int> Hatchery::getN(vector<Unit> UV, bool cheat){
	static map<UnitType, int> res;
	if (!cheat) res.clear();
	else return res;
	for (const auto& u : UV){
		UnitType UT = u->getType();
		if (UT == UnitTypes::Zerg_Hive){
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
			UT = UnitTypes::Zerg_Lair;
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
			UT = UnitTypes::Zerg_Hatchery;
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
		}
		else if (UT == UnitTypes::Zerg_Lair){
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
			UT = UnitTypes::Zerg_Hatchery;
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
		}
		else if (UT == UnitTypes::Zerg_Greater_Spire){
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
			UT = UnitTypes::Zerg_Spire;
			if (res.find(UT) == res.end()) res[UT] = 1;
			else res[UT]++;
		}
		else if (UT == UnitTypes::Zerg_Egg){
			auto& que = u->getTrainingQueue();
			if (que.size() > 0){
				if (res.find(que.front()) == res.end()) res[que.front()] = 1;
				else res[que.front()]++;
				if (que.front().isTwoUnitsInOneEgg()) res[que.front()]++;
			}
		}
		else if (UT == UnitTypes::Zerg_Lurker_Egg){
			if (res.find(UT) == res.end()) res[UnitTypes::Zerg_Lurker] = 1;
			else res[UnitTypes::Zerg_Lurker]++;
		}
		else if (res.find(UT) == res.end()) res[UT] = 1;
		else res[UT]++;
	}
	return res;
}

void Hatchery::push(Unit u, bool isML = false){
	HatchData data;
	data.multi = isML;
	hatchery[u] = data;
}

void Hatchery::pop(Unit u){
	hatchery.erase(u);
}

bool Hatchery::ok(Unit u, UnitType UT){
	if (UT == UnitTypes::Zerg_Overlord){
		if (u->canTrain(UT) && Broodwar->self()->minerals() - (mineral - uMineral) >= UT.mineralPrice()){
			return true;
		}
	}
	else if (u->canTrain(UT) && Broodwar->self()->minerals() - mineral >= UT.mineralPrice() && Broodwar->self()->gas() - gas >= UT.gasPrice() && larva > 0){
		larva--;
		return true;
	}
	return false;
}

int Hatchery::hasUnit(UnitType UT){
	int res = 0;
	for (const auto& u : All){
		if (u->getType() == UT) res++;
		else if (UT == UnitTypes::Zerg_Egg){
			auto& que = u->getTrainingQueue();
			if (que.size() > 0){
				if (que.front() == UT) res++;
				if (que.front().isTwoUnitsInOneEgg()) res++;
			}
		}
	}
	return res;
}

tuple<UpgradeInfo, tuple<Unit, TilePosition>> Hatchery::refresh(bool Gas, UnitInfo UI, vector<Unit> All_u, Resource reserved, BuildLocations BL, int overlord){
	UpgradeInfo upgrading;
	geysers.clear();
	mineral = reserved.mineral;
	gas = reserved.gas;
	larva = reserved.larva;
	uMineral = reserved.uMineral;
	All = All_u;

	bool once_over = true;

	vector< tuple<UnitType, int> > units = sort(UI);

	for (const auto& MI : hatchery){
		Unit u = MI.first;
		unsigned M = 0; // Minerals
		unsigned D = 0; // Mineral-mining drones
		unsigned G = 0; // Gas-mining drones
		bool Defense = false;
		if (MI.second.multi){
			for (const auto& uu : u->getUnitsInRadius(400)){
				if (IsEnemy(uu)){
					if (uu->getType().airWeapon().damageAmount() > 0 || uu->getType().groundWeapon().damageAmount() > 0 || uu->getEnergy() > 0) Defense = true;
				}
				if (uu->getType().isMineralField()) M++;
				if (uu->getType().isWorker() && IsOwned(uu) && uu->isGatheringMinerals()) D++;
				if (uu->getType().isWorker() && IsOwned(uu) && uu->isGatheringGas()) G++;
			}
			if (D > 6 && Gas){
				Unit geyser = u->getClosestUnit(GetType == UnitTypes::Resource_Vespene_Geyser && IsNeutral, 300);
				if (geyser){
					Broodwar->drawCircleMap(geyser->getPosition(), 5, Colors::Red, true);
					geysers.push_back(geyser);
				}
			}
			Unit geyser = u->getClosestUnit(IsOwned && !IsBeingConstructed && GetType == UnitTypes::Zerg_Extractor, 300);
			if (geyser){
				if (G > 3){
					Unit come = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
						IsGatheringGas && !IsCarryingSomething);
					if (come) come->stop();
				}
				else if (G < 2 && D > 6){
					Unit ggg = u->getClosestUnit(GetType == u->getType().getRace().getWorker() &&
						(IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
					if (ggg){
						if (ggg->canGather(geyser)){
							ggg->gather(geyser);
						}
					}
				}
			}

			if (M * 1.5 <= D){
				hatchery[u] = HatchData(true);
				Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Green, hatchery[u].satisfied);
			}
			else{
				Broodwar->drawCircleMap(u->getPosition(), 5, Colors::Green);
				hatchery[u] = HatchData(false);
			}
		}
		
		for (auto& larva : u->getLarva()){
			// Overlord spawn
			if (overlord * 16 + hatchery.size() * 2 - Broodwar->self()->supplyUsed() < hatchery.size() * 2 + 2 && hatchery.size() * 2 + overlord * 16 < 400 &&
				ok(larva, UnitTypes::Zerg_Overlord) && once_over){
				getN(All, true)[UnitTypes::Zerg_Overlord]++;
				larva->train(UnitTypes::Zerg_Overlord);
				once_over = false;
				continue;
			}
			if (MI.second.multi && !Defense){
				// Drone
				if (UI.drone == UnitInfo::Drone::Irrelative){
					if (larva->canMorph(UnitTypes::Zerg_Drone) && getN(All, true)[UnitTypes::Zerg_Drone] < UI.drone_number && getN(All, true)[UnitTypes::Zerg_Drone] < 70){
						getN(All, true)[UnitTypes::Zerg_Drone]++;
						larva->morph(UnitTypes::Zerg_Drone);
						All.push_back(larva);
						continue;
					}
				}
				else if (UI.drone == UnitInfo::Drone::Relative){
					if (larva->canMorph(UnitTypes::Zerg_Drone) && getN(All, true)[UnitTypes::Zerg_Drone] < unsatisfied().size() * UI.drone_number && getN(All, true)[UnitTypes::Zerg_Drone] < 70){
						getN(All, true)[UnitTypes::Zerg_Drone]++;
						larva->morph(UnitTypes::Zerg_Drone);
						All.push_back(larva);
						continue;
					}
				}
				else if (UI.drone == UnitInfo::Drone::Default){
					if (larva->canMorph(UnitTypes::Zerg_Drone) && D < M && getN(All, true)[UnitTypes::Zerg_Drone] < 70){
						getN(All, true)[UnitTypes::Zerg_Drone]++;
						larva->morph(UnitTypes::Zerg_Drone);
						All.push_back(larva);
						continue;
					}
				}
			}
			// Units
			bool Defaults = true;
			for (auto& U : units){
				UnitType UT;  int n;
				tie(UT, n) = U;
				if (UT == UnitTypes::Zerg_Lurker) continue;
				if (n > 0){
					if (getN(All, true)[UT] < n) Defaults = false;
				}
			}
			for (const auto& U : units){
				UnitType UT;  int n;
				tie(UT, n) = U;
				if (n > 0){
					if (getN(All, true)[UT] < n){
						if (larva->canTrain(UT)){
							getN(All, true)[UT]++;
							if (UT.isTwoUnitsInOneEgg()) getN(All, true)[UT]++;
							larva->train(UT);
						}
						else
							Broodwar->drawCircleMap(larva->getPosition(), 5, Colors::Orange, true);
					}
					else Broodwar->drawCircleMap(larva->getPosition(), 5, Colors::Red, true);
				}
				else if(Defaults){
					if (ok(larva, UT)){
						getN(All, true)[UT]++;
						if (UT.isTwoUnitsInOneEgg()) getN(All, true)[UT]++;
						larva->train(UT);
					}
				}
			}
		}
	}
	TilePosition tile;
	tuple<Unit, TilePosition> H = make_tuple((Unit)NULL, tile);
	if (Broodwar->self()->minerals() - mineral > 500){
		if (MORE == BuildInfo::Hatchery::Expand){
			/* Multi & Extra */
			Unit u = RandomHatchery();
			if (u){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				if (hatchery.size() <= 6 && hatchery.size() < MLHatchery().size() * 2 - 1){
					/* Extra */
					tile = Broodwar->getBuildLocation(UnitTypes::Zerg_Hatchery, u->getTilePosition(), 300);
				}
				else{
					/* Multi */
					tile = BL.getML();
				}
				if (builder, tile) H = make_tuple(builder, tile);
			}
		}
		else if (MORE == BuildInfo::Hatchery::Extra){
			/* Extra Only */
			Unit u = RandomHatchery();
			if (u){
				Unit builder = u->getClosestUnit(GetType == u->getType().getRace().getWorker() && (IsGatheringMinerals) && IsOwned && !IsCarryingSomething);
				tile = Broodwar->getBuildLocation(UnitTypes::Zerg_Hatchery, u->getTilePosition(), 300);
				if (builder, tile) H = make_tuple(builder, tile);
			}
		}
		else if (MORE == BuildInfo::Hatchery::Limited){
			/* No Hatchery */
		}
	}

	return make_tuple(upgrading,H);
}

Unit Hatchery::RandomHatchery(){
	if (hatchery.size() == 0) return NULL;
	int k = Broodwar->getFrameCount() % hatchery.size();
	int K = 0;
	map<Unit, HatchData>::iterator CI;
	for (CI = hatchery.begin(); CI != hatchery.end(); ++CI){
		if (K == k) return CI->first;
		K++;
	}
	return NULL;
}

vector<Unit> Hatchery::getGeysers()
{return geysers;}

vector<Unit> Hatchery::MLHatchery(){
	vector<Unit> res;
	for (const auto& H : hatchery){
		if (H.second.multi) res.push_back(H.first);
	}
	return res;
}

vector<Unit> Hatchery::unsatisfied(){
	vector<Unit> res;
	for (const auto& MI : hatchery){
		if (MI.second.multi && MI.second.satisfied == false) res.push_back(MI.first);
	}
	return res;
}