#include "UXManager_Additional.h"

using namespace MyBot;

UXManager_Additional::UXManager_Additional()
{
}

UXManager_Additional & UXManager_Additional::Instance()
{
	static UXManager_Additional instance;
	return instance;
}


void UXManager_Additional::onStart()
{
}

void UXManager_Additional::update()
{
	// APM ǥ
	BWAPI::Broodwar->drawTextScreen(5, 41, "APM : %d", BWAPI::Broodwar->getAPM());

	// TODO : ŸӾƿ Ǹ ŵѴ
	drawStrategy(400, 170);
	drawStrategicTaskList(400, 200);

	drawSquadUnitCountOnScreen(400, 60);
	drawSquadNameOnUnit();

	drawBaseLocationInfo();
	drawSafePositions();

	if (StrategyManager::Instance().mainCombatMutaliskSquad.unitset.size() >= 0) {

		BWAPI::Broodwar->drawTextScreen(400, 150, "mainCombatMutaliskSquad center %d, %d",
			StrategyManager::Instance().mainCombatMutaliskSquad.unitset.getPosition().x / TILE_SIZE, StrategyManager::Instance().mainCombatMutaliskSquad.unitset.getPosition().y / TILE_SIZE);
	}

	/*
	int geyserNumber = 0;
	for (auto & geyser : BWAPI::Broodwar->getStaticGeysers())
	{
		// geyser->getType()  ϸ, Unknown ̰ų, Resource_Vespene_Geyser ̰ų, Terran_Refinery   ǹ , 
		// ǹ ıǾ ڵ Resource_Vespene_Geyser  ư ʴ´

		BWAPI::Position geyserPos = geyser->getInitialPosition();
		BWAPI::TilePosition geyserTilePos = geyser->getInitialTilePosition();

		// ̹  ִ°
		bool refineryAlreadyBuilt = false;
		BWAPI::Unitset alreadyBuiltUnits = BWAPI::Broodwar->getUnitsInRadius(geyserPos, 4 * TILE_SIZE);
		for (auto & u : alreadyBuiltUnits) {
			if (u->getType().isRefinery() && u->exists()) {
				refineryAlreadyBuilt = true;
				break;
			}
		}

		BWAPI::Broodwar->drawTextMap(geyserPos.x, geyserPos.y + 10, "%s %s %d", geyser->getType().c_str(), geyser->getPlayer()->getName().c_str(), refineryAlreadyBuilt);
	}
	*/



	// ߰
	if (StrategyManager::Instance().myMainBaseLocation != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().myMainBaseLocation->getPosition(), "Main BaseLocation");
	}
	if (StrategyManager::Instance().myFirstChokepoint != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().myFirstChokepoint->getCenter(), "First ChokePoint");
	}
	if (StrategyManager::Instance().myFirstExpansionBaseLocation != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().myFirstExpansionBaseLocation->getPosition(), "First ExpansionLocation");
	}

	if (StrategyManager::Instance().enemyMainBaseLocation != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().enemyMainBaseLocation->getPosition(), "Main BaseLocation");
	}
	if (StrategyManager::Instance().enemyFirstChokepoint != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().enemyFirstChokepoint->getCenter(), "First ChokePoint");
	}
	if (StrategyManager::Instance().enemyFirstExpansionBaseLocation != nullptr) {
		BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().enemyFirstExpansionBaseLocation->getPosition(), "First ExpansionLocation");
	}


	// frontlineChokepointList

	int i = 0;
	for (auto & chokepoint : StrategyManager::Instance().frontlineChokepointList) {
		BWAPI::Broodwar->drawTextMap(chokepoint->getCenter().x, chokepoint->getCenter().y + 10, "frontlineChokepoint");
		//BWAPI::Broodwar->drawTextScreen(200, 260 + i * 10, "frontlineChokepoint %d,%d", chokepoint->getCenter().x / TILE_SIZE, chokepoint->getCenter().y / TILE_SIZE);
		i++;
	}

	BWAPI::Broodwar->drawCircleMap(StrategyManager::Instance().frontlinePosition, 4 * TILE_SIZE, BWAPI::Colors::Orange);
	BWAPI::Broodwar->drawTextMap(StrategyManager::Instance().frontlinePosition, "frontlinePosition");
	//BWAPI::Broodwar->drawTextScreen(200, 250, "frontlinePosition %d,%d", StrategyManager::Instance().frontlinePosition.x / TILE_SIZE, StrategyManager::Instance().frontlinePosition.y / TILE_SIZE);

	//  
	BWAPI::Broodwar->drawTextScreen(400, 30, "CombatState : %d", Strategy_CombatTaskManager::Instance().combatState);

	if (Strategy_CombatTaskManager::Instance().targetAssemblePositionForGroundUnits != BWAPI::Positions::None) {

		BWAPI::Position position = Strategy_CombatTaskManager::Instance().targetAssemblePositionForGroundUnits;

		BWAPI::Broodwar->drawCircleMap(position, 2 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 4 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 6 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 8 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawTextMap(position, "targetAssemblePositionForGroundUnits");
	}

	if (Strategy_CombatTaskManager::Instance().targetAttackPositionForGroundUnits != BWAPI::Positions::None) {

		BWAPI::Position position = Strategy_CombatTaskManager::Instance().targetAttackPositionForGroundUnits;

		BWAPI::Broodwar->drawCircleMap(position, 2 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 4 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 6 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawCircleMap(position, 8 * TILE_SIZE, BWAPI::Colors::Purple);
		BWAPI::Broodwar->drawTextMap(position.x, position.y + 10, "targetAttackPositionForGroundUnits");
	}

	if (Strategy_CombatTaskManager::Instance().targetAssemblePositionForAirUnits != BWAPI::Positions::None) {

		BWAPI::Position position = Strategy_CombatTaskManager::Instance().targetAssemblePositionForAirUnits;

		BWAPI::Broodwar->drawCircleMap(position, 2 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 4 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 6 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 8 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawTextMap(position, "targetAssemblePositionForAirUnits");
	}

	if (Strategy_CombatTaskManager::Instance().targetAttackPositionForAirUnits != BWAPI::Positions::None) {

		BWAPI::Position position = Strategy_CombatTaskManager::Instance().targetAttackPositionForAirUnits;

		BWAPI::Broodwar->drawCircleMap(position, 2 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 4 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 6 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawCircleMap(position, 8 * TILE_SIZE, BWAPI::Colors::Orange);
		BWAPI::Broodwar->drawTextMap(position.x, position.y+10, "targetAttackPositionForAirUnits");
	}

	// fakeMineral
	for (BWTA::BaseLocation* baselocation : BWTA::getStartLocations()) {
		BWAPI::TilePosition tileposition = StrategyManager::Instance().getNearestBaseLocationPositionBlockedByFakeMineral(baselocation->getTilePosition());
		if (tileposition != BWAPI::TilePositions::None) {
			BWAPI::Broodwar->drawTextMap(tileposition.x * TILE_SIZE, tileposition.y * TILE_SIZE, "BaseLocationPositionBlockedByFakeMineral");
		}
	}

	/*
	// 
	BWAPI::Broodwar->drawTextScreen(200, 280, "scoutOverlordSquad1 : %d", StrategyManager::Instance().scoutOverlordSquad1.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 290, "scoutOverlordSquad2 : %d", StrategyManager::Instance().scoutOverlordSquad2.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 300, "scoutOverlordSquad3 : %d", StrategyManager::Instance().scoutOverlordSquad3.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 310, "scoutOverlordSquad4 : %d", StrategyManager::Instance().scoutOverlordSquad4.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 310, "scoutOverlordSquad5 : %d", StrategyManager::Instance().scoutOverlordSquad5.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 320, "scoutDroneSquad : %d", StrategyManager::Instance().scoutDroneSquad.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 330, "scoutZerglingSquad : %d", StrategyManager::Instance().scoutZerglingSquad.unitset.size());
	BWAPI::Broodwar->drawTextScreen(200, 340, "scoutScourgeSquad : %d", StrategyManager::Instance().scoutScourgeSquad.unitset.size());
	*/

	// confidence map
	drawConfidenceMapForMutalisk();

	/*
	Squad* currentSquad = nullptr;
	for (int i = 0; i < 11; i++) {
		if (i == 0) currentSquad = &StrategyManager::Instance().scoutOverlordSquad1;
		else if (i == 1) currentSquad = &StrategyManager::Instance().scoutOverlordSquad2;
		else if (i == 2) currentSquad = &StrategyManager::Instance().scoutOverlordSquad3;
		else if (i == 3) currentSquad = &StrategyManager::Instance().scoutOverlordSquad4;
		else if (i == 4) currentSquad = &StrategyManager::Instance().scoutOverlordSquad5;
		else if (i == 5) currentSquad = &StrategyManager::Instance().scoutDroneSquad;
		else if (i == 6) currentSquad = &StrategyManager::Instance().scoutZerglingSquad;
		else if (i == 7) currentSquad = &StrategyManager::Instance().scoutScourgeSquad;
		else if (i == 8) currentSquad = &StrategyManager::Instance().scoutQueenSquad;
		else if (i == 9) currentSquad = &StrategyManager::Instance().multiObstructZerglingSquad;
		else if (i ==10) currentSquad = &StrategyManager::Instance().multiObstructLurkerSquad;

		for (auto & unit : currentSquad->unitset) {
			Mission* mission = currentSquad->getUnitMission(unit);
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 15, "mission : %d", mission->missionType);
			if (mission->missionType == MissionType::Move) {
				BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 35, "target : %d, %d", mission->targetPosition.x / TILE_SIZE, mission->targetPosition.y / TILE_SIZE);
			}
		}
	}
	*/

	// BaseLocation  GroundDistance Ÿ
	// TODO : Ƽ fakeMineral  
	/*
	for (BWTA::BaseLocation* fromBase : BWTA::getBaseLocations()) {
		for (BWTA::BaseLocation* toBase : BWTA::getBaseLocations()) {

			double distance = fromBase->getGroundDistance(toBase);
			if (distance > 0) {
				BWAPI::Position middle;
				middle.x = (int)((fromBase->getPosition().x + toBase->getPosition().x) * 0.5);
				middle.y = (int)((fromBase->getPosition().y + toBase->getPosition().y) * 0.5);

				BWAPI::Broodwar->drawTextMap(middle, "distance %10.0f", distance);
				BWAPI::Broodwar->drawLineMap(fromBase->getPosition(), toBase->getPosition(), BWAPI::Colors::Green);
			}

		}
	}
	*/

	//    ǥ
	for (auto & kv : InformationManager::Instance().getUnitData(BWAPI::Broodwar->enemy()).getUnitAndUnitInfoMap())
	{
		BWAPI::Unit unit = kv.first;
		UnitInfo & ui(kv.second);

		if (unit == nullptr || unit->exists() == false || unit->isCompleted() == false) {
			continue;
		}

		BWAPI::UnitType type(ui.type);
		const BWAPI::Position & pos = ui.lastPosition;

		int left = pos.x - type.dimensionLeft();
		int right = pos.x + type.dimensionRight();
		int top = pos.y - type.dimensionUp();
		int bottom = pos.y + type.dimensionDown();

		//  ̸  ڽ ǥ
		//if (!BWAPI::Broodwar->isVisible(BWAPI::TilePosition(ui.lastPosition)))
		if (true)
		{
			BWAPI::Broodwar->drawBoxMap(BWAPI::Position(left, top), BWAPI::Position(right, bottom), BWAPI::Colors::Grey, false);
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 4), "%s", ui.type.getName().c_str());
			// ߰ 
			if (ui.isLastPositionValid) {
				BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 14), "lastPosition valid");
			}
			else {
				BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 14), "lastPosition invalid");
			}
		}

		// Parasited
		if (unit->isParasited()) {
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 24), "Parasited");
		}
		if (ui.isAssignedAsParasiteTarget) {
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 34), "Parasite assigned");
		}
		// Ensnared
		if (unit->isEnsnared()) {
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 44), "Ensnared");
		}
		if (ui.isAssignedAsEnsnareTarget) {
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 54), "Ensnare assigned");
		}
		// Broodling
		if (ui.isAssignedAsSpawnBroodlingsTarget) {
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(left + 3, top + 64), "SpawnBroodlings assigned");
		}
	}

	// Ʊ  ǥ
	for (auto & kv : InformationManager::Instance().getUnitData(BWAPI::Broodwar->self()).getUnitAndUnitInfoMap())
	{
		BWAPI::Unit unit = kv.first;
		UnitInfo & ui(kv.second);

		if (unit == nullptr || unit->exists() == false || unit->isCompleted() == false) {
			continue;
		}

		BWAPI::UnitType type(ui.type);
		const BWAPI::Position & pos = ui.lastPosition;

		// Replay  getLastCommand  ׻ None ̾ Ұ
		// 
		//BWAPI::Order order = unit->getOrder();
		//if (order != BWAPI::Orders::None)
		//{
		//	BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y - 5, "%s", order.toString());
		//}

		/*
		if (unit->isConstructing()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isConstructing");
		}
		if (unit->isGatheringMinerals()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isGatheringMinerals");
		}
		if (unit->isGatheringGas()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isGatheringGas");
		}
		if (unit->isIdle()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isIdle");
		}
		if (unit->isResearching()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isResearching");
		}
		if (unit->isUpgrading()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isUpgrading");
		}
		if (unit->isTraining()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 25, "isTraining");
		}

		if (unit->isAttacking()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 35, "isAttacking");
		}
		if (unit->isMoving()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 35, "isMoving");
		}

		if (unit->isUnderAttack()) {
			BWAPI::Broodwar->drawTextMap(unit->getPosition().x, unit->getPosition().y + 45, "isUnderAttack");
		}
		*/

		/*
		if (unit->getType() == BWAPI::UnitTypes::Zerg_Zergling) {
			std::cout 
				<< "At " << BWAPI::Broodwar->getFrameCount() << " : "
				<< unit->getID() << " "
				<< " isIdle " << unit->isIdle()
				<< " isMoving " << unit->isMoving()
				<< " isAccelerating " << unit->isAccelerating()
				<< " isBraking " << unit->isBraking()
				<< " isStartingAttack " << unit->isStartingAttack()
				<< " isAttackFrame " << unit->isAttackFrame()
				<< " isAttacking " << unit->isAttacking()
				<< " positionBeforeRecordFrame " << ui.positionBeforeRecordFrame
				<< " ui.positionBefore " << ui.positionBefore.x << "," << ui.positionBefore.y
				<< " lastPositionRecordFrame " << ui.lastPositionRecordFrame
				<< " ui.lastPosition " << ui.lastPosition.x << "," << ui.lastPosition.y

				<< std::endl;
		}
		*/
	}
	
}

void UXManager_Additional::drawSafePositions()
{
	auto & theMap = BWEM::Map::Instance();

	// ʹ  ϸ, ޸ ų,  Ʈ ü ۵ 
	int i = 0;
	for (auto it = StrategyManager::Instance().safeLevel9Positions->begin(); it != StrategyManager::Instance().safeLevel9Positions->end(); it++) {
		i++;
		// 30 1 
		if (i % 30 != 0) continue;
		if (theMap.Valid(BWAPI::Position((*it).x * 8, (*it).y * 8))) {
			BWAPI::Broodwar->drawTextMap((*it).x * 8, (*it).y * 8, "9");
		}
	}

	for (auto it = StrategyManager::Instance().safeLevel5Positions->begin(); it != StrategyManager::Instance().safeLevel5Positions->end(); it++) {
		i++;
		// 50 1 
		if (i % 50 != 0) continue;
		if (theMap.Valid(BWAPI::Position((*it).x * 8, (*it).y * 8))) {
			BWAPI::Broodwar->drawTextMap((*it).x * 8, (*it).y * 8, "5");
		}
	}
}

void UXManager_Additional::drawChokepointStatus()
{
	for (BWTA::Chokepoint* chokepoint : BWTA::getChokepoints()) {

		auto & sidePositions = chokepoint->getSides();
		BWAPI::Position left = sidePositions.first;
		BWAPI::Position right = sidePositions.second;

		double chokepointDistance = left.getDistance(right);
		int neededUnitCount = (int)(chokepointDistance / 20);

		BWAPI::Broodwar->drawTextMap(chokepoint->getCenter().x, chokepoint->getCenter().y + 10, "%d (%d units)", chokepointDistance, neededUnitCount);
	}
}


void UXManager_Additional::drawBaseLocationInfo()
{
	for (auto & kv : StrategyManager::Instance().baseLocationStatusMap)
	{
		BWTA::BaseLocation* baseLocation = kv.first;
		LocationInfo baseLocationInfo = kv.second;
		LocationStatus status = baseLocationInfo.locationStatus;
		
		if (status == LocationStatus::Enemy_Occupied) {
			BWAPI::Broodwar->drawTextMap(baseLocation->getPosition().x, baseLocation->getPosition().y + 40, "Enemy_Occupied");
		}
		else if (status == LocationStatus::LocationStatus_Unknown) {
			BWAPI::Broodwar->drawTextMap(baseLocation->getPosition().x, baseLocation->getPosition().y + 40, "LocationStatus_Unknown");
		}

		BWAPI::Broodwar->drawTextMap(baseLocation->getPosition().x, baseLocation->getPosition().y - 10, "dangeroudLevel : %d", baseLocationInfo.lastDangerousLevel);
	}

}

void UXManager_Additional::drawSquadUnitCountOnScreen(int x, int y)
{
	if (Config::Debug::DrawSquadList) {

		if (StrategyManager::Instance().allMySquadList.size() > 0) {
			for (Squad* squad : StrategyManager::Instance().allMySquadList) {
				if (squad != nullptr) {
					if (squad->unitset.size() > 0) {
						BWAPI::Broodwar->drawTextScreen(x, y, "%d=%s", squad->unitset.size(), squad->squadName.c_str());
						y += 10;
					}
				}
			}
		}
	}
}

void UXManager_Additional::drawSquadNameOnUnit()
{
	if (Config::Debug::DrawSquadName) {

		for (Squad* squad : StrategyManager::Instance().allMySquadList) {

			//if (squad == &(StrategyManager::Instance().reservedSquad)) continue;

			for (auto it = squad->unitset.begin(); it != squad->unitset.end(); ++it){
				if (*it != nullptr && (*it)->exists() && (*it)->getHitPoints() > 0) {

					BWAPI::Broodwar->drawTextMap((*it)->getPosition().x, (*it)->getPosition().y + 15, squad->squadName.c_str());
				}
			}
		}
	}
}

void UXManager_Additional::drawStrategy(int x, int y)
{
	BWAPI::Broodwar->drawTextScreen(x, y, "<Strategy>");
	y += 10;

	BWAPI::Broodwar->drawTextScreen(x, y, "My Strategy : Build %d Combat %d", 
		StrategyManager::Instance().myCurrentBuildStrategy,
		StrategyManager::Instance().myCurrentCombatStrategy
	);
	y += 10;

	BWAPI::Broodwar->drawTextScreen(x, y, "Enemy Strategy : Build %d Combat %d",
		StrategyManager::Instance().enemyCurrentBuildStrategy,
		StrategyManager::Instance().enemyCurrentCombatStrategy
	);
}

void UXManager_Additional::drawStrategicTaskList(int x, int y)
{
	BWAPI::Broodwar->drawTextScreen(x, y, "<Task List>");
	y += 10;

	std::string str;
	for (auto & task : StrategyManager::Instance().taskList) {

		if (task.taskGoal == TaskGoalType::Scout_Empty_BaseLocations
			|| task.taskGoal == TaskGoalType::Scout_Enemy_Chokepoint
			|| task.taskGoal == TaskGoalType::Scout_Enemy_First_Expansion
			|| task.taskGoal == TaskGoalType::Scout_Enemy_MainBaseLocation
			|| task.taskGoal == TaskGoalType::Scout_Enemy_Other_Expansion
		){
			continue;
		}

		if (task.taskGoal == TaskGoalType::Burrow_On_Empty_BaseLocation) {
			BWAPI::Broodwar->drawCircleMap(task.targetPosition, 5, BWAPI::Colors::Purple, true);
			BWAPI::Broodwar->drawTextMap(task.targetPosition.x, task.targetPosition.y + 10, "toBurrow");
		}
		
		str = StrategicTaskUtil::toString(task);
		
		BWAPI::Broodwar->drawTextScreen(x, y, "%s", str.c_str());
		y += 10;
	}

}



void UXManager_Additional::drawConfidenceMapForMutalisk()
{
	for (int j = 0; j < StrategyManager::Instance().confidenceMapForMutalisk->Height(); ++j) {
		for (int i = 0; i < StrategyManager::Instance().confidenceMapForMutalisk->Width(); ++i) {

			ConfidenceMapCell & cell = StrategyManager::Instance().confidenceMapForMutalisk->GetCell(i, j);

			//if (cell.groundDamagePerSecond > 0) {
			//	BWAPI::Broodwar->drawTextMap(i * TILE_SIZE + 16, j * TILE_SIZE, "%d", cell.groundDamagePerSecond);
			//}
			if (cell.airDamagePerSecond > 0) {
				BWAPI::Broodwar->drawTextMap(i * TILE_SIZE + 16, j * TILE_SIZE + 16, "%d", cell.airDamagePerSecond);
			}
		}
	}

}

