#include "Strategy_ExpansionTaskManager.h"

using namespace MyBot;

Strategy_ExpansionTaskManager & Strategy_ExpansionTaskManager::Instance()
{
	static Strategy_ExpansionTaskManager instance;
	return instance;
}

Strategy_ExpansionTaskManager::Strategy_ExpansionTaskManager()
{
	isBuildQueueEnqueued = false;
	targetBaseLocation = nullptr;
}

void Strategy_ExpansionTaskManager::setCompleted()
{
	isBuildQueueEnqueued = false;
	targetBaseLocation = nullptr;
}

void Strategy_ExpansionTaskManager::update()
{
	for (auto it = StrategyManager::Instance().taskList.begin(); it != StrategyManager::Instance().taskList.end();) {
		if ((*it).taskGoal == TaskGoalType::Build_Expansion_On_Ground) {
			buildExpansionOnGround(*it);
		}
		++it;
	}

	/*
	if (StrategyManager::Instance().taskList.find(StrategicTask(Build_Expansion_On_Island)) != StrategyManager::Instance().taskList.end())
	{
		buildExpansionOnIsland(*(StrategyManager::Instance().taskList.find(StrategicTask(Build_Expansion_On_Island))));
	}

	*/

	//  
	StrategyManager::Instance().newExpansionSetupSquad.executeMission();

	drawExpansion();

}

void Strategy_ExpansionTaskManager::drawExpansion()
{
}

void Strategy_ExpansionTaskManager::buildExpansionOnGround(StrategicTask task)
{
	// 1ʿ ѹ 
	if (BWAPI::Broodwar->getFrameCount() % 24 != 0) {
		return;
	}

	//std::cout << "3";
	if (isBuildQueueEnqueued == false) {
		targetBaseLocation = StrategyManager::Instance().getMyNextExpansionLocation(task.taskGoal);

		if (targetBaseLocation != nullptr) {

			BWAPI::TilePosition targetTilePosition = targetBaseLocation->getTilePosition();
			//std::cout << "4";

			if (BuildManager::Instance().buildQueue.isEmpty() == false) {
				BuildOrderItem currentItem = BuildManager::Instance().buildQueue.getHighestPriorityItem();
				if (currentItem.metaType.isUnit() == false || currentItem.metaType.getUnitType() != BWAPI::UnitTypes::Zerg_Hatchery)
				{
					BuildManager::Instance().buildQueue.queueAsHighestPriority(BWAPI::UnitTypes::Zerg_Hatchery, targetTilePosition, false);
					isBuildQueueEnqueued = true;
				}
			}
			else {
				BuildManager::Instance().buildQueue.queueAsHighestPriority(BWAPI::UnitTypes::Zerg_Hatchery, targetTilePosition, false);
				isBuildQueueEnqueued = true;
			}
			//std::cout << "5";
		}
	}

	if (isBuildQueueEnqueued == true) {
		//std::cout << "6";

		if (targetBaseLocation != nullptr) {
			BWAPI::TilePosition targetTilePosition = targetBaseLocation->getTilePosition();
			// ǥ
			//BWAPI::Broodwar->drawCircleMap(targetTilePosition.x * TILE_SIZE, targetTilePosition.y * TILE_SIZE, 5 * TILE_SIZE, BWAPI::Colors::Blue, false);

			//std::cout << "7";
			for (auto & unit : StrategyManager::Instance().newExpansionSetupSquad.unitset) {

				Mission* unitMission = StrategyManager::Instance().newExpansionSetupSquad.getUnitMission(unit);

				if (unit->getDistance(targetBaseLocation->getPosition()) > 8 * TILE_SIZE) {
					StrategyManager::Instance().newExpansionSetupSquad.setUnitMission(unit, Mission(MissionType::Move, targetBaseLocation->getPosition()));
				}
				else if (unit->getDistance(targetBaseLocation->getPosition()) > 3 * TILE_SIZE) {
					StrategyManager::Instance().newExpansionSetupSquad.setUnitMission(unit, Mission(MissionType::AttackMove, targetBaseLocation->getPosition()));
				}
			}
		}
	}
	//std::cout << "8";
}

void Strategy_ExpansionTaskManager::buildExpansionOnIsland(StrategicTask task)
{
	// TODO : ε忡 ¿ 
	if (StrategyManager::Instance().newExpansionSetupSquad.unitset.size() > 0) {

		int nonWorkerCountAroundMainBase = 0;
		for (auto & unit : StrategyManager::Instance().newExpansionSetupSquad.unitset) {
		}
	}

}

