#include "Strategy_CombatTaskManager.h"

using namespace MyBot;


void Strategy_CombatTaskManager::updateUnitCount()
{
	//  MainBaseLocation   
	enemyCombatUnitCount = InformationManager::Instance().getNumUnits(InformationManager::Instance().getBasicCombatUnitType(InformationManager::Instance().enemyRace), InformationManager::Instance().enemyPlayer);
	enemyWorkerUnitCount = InformationManager::Instance().getNumUnits(InformationManager::Instance().getWorkerType(InformationManager::Instance().enemyRace), InformationManager::Instance().enemyPlayer);
	enemyZealotCount = InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Protoss_Zealot, InformationManager::Instance().enemyPlayer);
	enemyMarineCount = InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Terran_Marine, InformationManager::Instance().enemyPlayer);
	enemyZerglingCount = InformationManager::Instance().getNumUnits(BWAPI::UnitTypes::Zerg_Zergling, InformationManager::Instance().enemyPlayer);

	BWTA::BaseLocation * enemyMainBaseLocation = InformationManager::Instance().getMainBaseLocation(InformationManager::Instance().enemyPlayer);
	if (enemyMainBaseLocation != nullptr) {

		enemyWorkerUnitAroundEnemyBase = 0;
		enemyWorkerUnitAroundEnemyChokepoint = 0;
		enemyCombatUnitAroundEnemyBase = 0;
		enemyCombatUnitAroundEnemyChokepoint = 0;
		enemyBuildingAroundEnemyBase = 0;
		enemyBuildingAroundEnemyChokepoint = 0;
		enemyDefenseBuildingAroundEnemyBase = 0;
		enemyDefenseBuildingAroundEnemyChokepoint = 0;

		for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(StrategyManager::Instance().enemyPlayer)) {
			BWAPI::Unit enemyUnit = it.first;
			UnitInfo & enemyUnitInfo = it.second;

			if (enemyUnitInfo.lastHealth == 0) {
				continue;
			}

			if (BWTA::getRegion(enemyUnitInfo.lastPosition) == enemyMainBaseLocation->getRegion()) {
				if (enemyUnitInfo.type.isWorker()) {
					enemyWorkerUnitAroundEnemyBase++;
				}
				if (enemyUnitInfo.type.isBuilding()) {
					enemyBuildingAroundEnemyBase++;
				}
				if (enemyUnitInfo.type.canAttack() && enemyUnitInfo.type.isWorker() == false && enemyUnitInfo.type.isBuilding() == false) {
					enemyCombatUnitAroundEnemyBase++;
				}
				if (enemyUnitInfo.type.canAttack() && enemyUnitInfo.type.isBuilding() == true) {
					enemyDefenseBuildingAroundEnemyBase++;
				}

			}
			else if (enemyUnitInfo.lastPosition.getDistance(StrategyManager::Instance().enemyFirstChokepoint->getCenter()) < 5 * TILE_SIZE)
			{
				if (enemyUnitInfo.type.isWorker()) {
					enemyWorkerUnitAroundEnemyChokepoint++;
				}
				if (enemyUnitInfo.type.isBuilding()) {
					enemyBuildingAroundEnemyChokepoint++;
				}
				if (enemyUnitInfo.type.canAttack() && enemyUnitInfo.type.isWorker() == false && enemyUnitInfo.type.isBuilding() == false) {
					enemyCombatUnitAroundEnemyChokepoint++;
				}
				if (enemyUnitInfo.type.canAttack() && enemyUnitInfo.type.isBuilding() == true) {
					enemyDefenseBuildingAroundEnemyChokepoint++;
				}
			}
		}
	}
}

int Strategy_CombatTaskManager::getNumberOfSameTargeting(BWAPI::Unit targetUnit)
{
	if (targetUnit == nullptr) {
		return 0;
	}
	else {
		int count = 0;

		for (auto it : attackerTargetMap) {
			if (it.second == targetUnit) {
				count++;
			}
		}
		return count;
	}

}


BWAPI::Unit Strategy_CombatTaskManager::getNearestEnemyWorker(BWAPI::Position from, int radius)
{
	BWAPI::Unit targetUnit = nullptr;
	double minDistanceToNearbyWorker = 1000000000;
	double tempDistanceToNearbyWorker = 0;
	for (auto & enemyUnit : BWAPI::Broodwar->getUnitsInRadius(from, radius)) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;
		if (enemyUnit->getPlayer() == StrategyManager::Instance().enemyPlayer && enemyUnit->getType().isWorker()) {
			tempDistanceToNearbyWorker = from.getDistance(enemyUnit->getPosition());
			if (minDistanceToNearbyWorker > tempDistanceToNearbyWorker) {
				minDistanceToNearbyWorker = tempDistanceToNearbyWorker;
				targetUnit = enemyUnit;
			}
		}
	}

	return targetUnit;
}

BWAPI::Unit Strategy_CombatTaskManager::getNearestEnemyWorkerForMeleeAttack(BWAPI::Position from, int maxSameAttackerCount)
{
	BWAPI::Unit closestEnemyWorker = nullptr;

	//    ϲ ϳ  
	double minDistanceToAttack = 1000000000;
	double tempDistanceToAttack;
	
	//   ϲ 1 Ʊ ۸ 3 ϵ Ѵ
	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer))
	{
		BWAPI::Unit enemyUnit = it.first;
		const UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.type == InformationManager::Instance().getWorkerType(InformationManager::Instance().enemyRace))
		{
			if (getNumberOfSameTargeting(enemyUnit) < maxSameAttackerCount) {
				tempDistanceToAttack = from.getDistance(enemyUnitInfo.lastPosition);
				if (tempDistanceToAttack < minDistanceToAttack) {
					minDistanceToAttack = tempDistanceToAttack;
					closestEnemyWorker = enemyUnit;
				}
			}
		}
	}

	if (closestEnemyWorker == nullptr) {
		// ׷ ϱ , ׳    ϲ 
		for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer))
		{
			BWAPI::Unit enemyUnit = it.first;
			const UnitInfo & enemyUnitInfo = it.second;

			if (enemyUnitInfo.type == InformationManager::Instance().getWorkerType(InformationManager::Instance().enemyRace))
			{
				tempDistanceToAttack = from.getDistance(enemyUnitInfo.lastPosition);
				if (tempDistanceToAttack < minDistanceToAttack) {
					minDistanceToAttack = tempDistanceToAttack;
					closestEnemyWorker = enemyUnit;
				}
			}
		}
	}

	return closestEnemyWorker;

}


BWAPI::Unit Strategy_CombatTaskManager::getNearestAndWeakestEnemyGroundCombatUnit(BWAPI::Position from)
{
	BWAPI::Unit targetUnit = nullptr;

	double minDistanceToAttack = 1000000000;
	double tempDistanceToAttack = 0;
	int minHitPointToAttack = INT_MAX;
	int tempHitPointToAttack = 0;

	// BWAPI::Broodwar->enemy()->getUnits  ϸ, Ʊ ðŸ   ȸȵȴ
	// ׷, InformationManager::Instance().getUnitAndUnitInfoMap  ؾ Ѵ
	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer))
	{
		BWAPI::Unit enemyUnit = it.first;
		const UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.type.canAttack() == true
			&& enemyUnitInfo.type.isWorker() == false 
			&& enemyUnitInfo.type.isBuilding() == false)
		{
			tempDistanceToAttack = from.getDistance(enemyUnitInfo.lastPosition);
			if (tempDistanceToAttack < minDistanceToAttack) {
				minDistanceToAttack = tempDistanceToAttack;

				targetUnit = enemyUnit;
			}
			else if (tempDistanceToAttack == minDistanceToAttack) {
				tempHitPointToAttack = enemyUnitInfo.lastHealth + enemyUnitInfo.lastShields;
				if (tempHitPointToAttack < minHitPointToAttack) {
					minHitPointToAttack = tempHitPointToAttack;

					targetUnit = enemyUnit;
				}
			}
		}
	}


	if (targetUnit == nullptr || targetUnit->exists() == false || targetUnit->getHitPoints() == 0 || targetUnit->isVisible() == false) {
		for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits())
		{
			if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;
			if (enemyUnit->getType().canAttack() == true
				&& enemyUnit->getType().isWorker() == false
				&& enemyUnit->getType().isBuilding() == false)
			{
				tempDistanceToAttack = from.getDistance(enemyUnit->getPosition());
				if (tempDistanceToAttack < minDistanceToAttack) {
					minDistanceToAttack = tempDistanceToAttack;

					targetUnit = enemyUnit;
				}
				else if (tempDistanceToAttack == minDistanceToAttack) {
					tempHitPointToAttack = enemyUnit->getHitPoints() + enemyUnit->getShields();
					if (tempHitPointToAttack < minHitPointToAttack) {
						minHitPointToAttack = tempHitPointToAttack;

						targetUnit = enemyUnit;
					}
				}
			}
		}
	}

	return targetUnit;
}

BWAPI::Position Strategy_CombatTaskManager::getNearestEnemyUnitToGroundAttack(BWAPI::Position from)
{
	BWAPI::Position targetPosition = BWAPI::Positions::None;

	//     ϳ  
	double minDistanceToAttack = 1000000000;
	double tempDistanceToAttack = 0;
	int minHitPointToAttack = INT_MAX;
	int tempHitPointToAttack = 0;

	// BWAPI::Broodwar->enemy()->getUnits  ϸ, Ʊ ðŸ   ȸȵȴ
	// ׷, InformationManager::Instance().getUnitAndUnitInfoMap  ؾ Ѵ
	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer))
	{
		BWAPI::Unit enemyUnit = it.first;
		const UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.type.isFlyer() == false)
		{
			// ǹ ߿  н
			if (enemyUnit != nullptr && enemyUnit->exists() && enemyUnit->isFlying() == true) {
				continue;
			}

			tempDistanceToAttack = from.getDistance(enemyUnitInfo.lastPosition);
			if (tempDistanceToAttack < minDistanceToAttack) {
				minDistanceToAttack = tempDistanceToAttack;

				targetPosition = enemyUnitInfo.lastPosition;
			}
			else if (tempDistanceToAttack == minDistanceToAttack) {
				tempHitPointToAttack = enemyUnitInfo.lastHealth + enemyUnitInfo.lastShields;
				if (tempHitPointToAttack < minHitPointToAttack) {
					minHitPointToAttack = tempHitPointToAttack;

					targetPosition = enemyUnitInfo.lastPosition;
				}
			}
		}
	}

	return targetPosition;
}

bool Strategy_CombatTaskManager::isThereHealthyFriendUnitAround(BWAPI::Position from, int radius)
{
bool result = false;
for (auto & closeUnit : BWAPI::Broodwar->getUnitsInRadius(from, radius)) {
	if (closeUnit->getPlayer() == StrategyManager::Instance().selfPlayer
		&& closeUnit->getHitPoints() > 10)
	{
		result = true;
		break;
	}
}

return result;
}


BWAPI::Position Strategy_CombatTaskManager::getFarthestMineralPosition(BWAPI::Position from, BWTA::BaseLocation* baselocation)
{
	BWAPI::Position targetPosition;

	double maxDistance = 0;
	double tempDistance = 0;
	for (auto & mineral : baselocation->getStaticMinerals()) {

		tempDistance = from.getDistance(mineral->getInitialPosition());
		if (maxDistance < tempDistance) {
			maxDistance = tempDistance;
			targetPosition = mineral->getInitialPosition();
		}
	}

	return targetPosition;
}


bool Strategy_CombatTaskManager::isAllMineralExplored(BWTA::BaseLocation* baselocation)
{
	bool isAllMineralExplored = true;
	for (auto & mineral : baselocation->getStaticMinerals()) {
		if (BWAPI::Broodwar->isExplored(mineral->getTilePosition()) == false) {
			isAllMineralExplored = false;
		}
	}

	return isAllMineralExplored;
}

BWAPI::Unit Strategy_CombatTaskManager::getEnemyUnitAroundEnemyChokepointClosestToEnemyFirstExpansionLocation()
{
	BWAPI::Unit targetUnit = nullptr;

	if (StrategyManager::Instance().enemyFirstChokepoint != nullptr) {

		double minDistance = 1000000000;
		double tempDistance = 0;

		for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(StrategyManager::Instance().enemyPlayer)) {
			BWAPI::Unit enemyUnit = it.first;
			UnitInfo & enemyUnitInfo = it.second;

			if (enemyUnitInfo.lastHealth == 0) {
				continue;
			}

			if (enemyUnitInfo.lastPosition.getDistance(StrategyManager::Instance().enemyFirstChokepoint->getCenter()) < 4 * TILE_SIZE)
			{
				tempDistance = enemyUnitInfo.lastPosition.getDistance(StrategyManager::Instance().enemyFirstExpansionBaseLocation->getPosition());
				if (minDistance > tempDistance) {
					minDistance = tempDistance;
					targetUnit = enemyUnitInfo.unit;
				}
			}
		}
	}

	return targetUnit;

}

BWAPI::Unit Strategy_CombatTaskManager::getMostUrgentEnemyUnit()
{
	BWAPI::Unit mostUrgentTarget = nullptr;

	int minPriority = 10000;
	int tempPriority = 0;

	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(StrategyManager::Instance().enemyPlayer)) {
		BWAPI::Unit enemyUnit = it.first;
		UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.lastHealth == 0) {
			continue;
		}

		if (enemyUnit != nullptr && enemyUnit->exists() && enemyUnit->getHitPoints() > 0 && enemyUnit->isVisible()) {

			if (BWTA::getRegion(enemyUnit->getPosition()) == BWTA::getRegion(StrategyManager::Instance().enemyMainBaseLocation->getPosition())
				|| BWTA::getRegion(enemyUnit->getPosition()) == BWTA::getRegion(StrategyManager::Instance().enemyFirstExpansionBaseLocation->getPosition()))
			{
				tempPriority = 10;

				if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Photon_Cannon) {
					if (enemyUnit->isCompleted()) {
						if (enemyUnit->getHitPoints() < 30) {
							tempPriority = 1;
						}
						else {
							tempPriority = 9;
						}
					}
					else {
						tempPriority = 1;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Forge){
					if (enemyUnit->isCompleted()) {
						tempPriority = 7;
					}
					else {
						tempPriority = 4;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Pylon){
					if (enemyUnit->isCompleted()) {
						if (enemyUnit->getHitPoints() < 30) {
							tempPriority = 1;
						}
						else {
							tempPriority = 3;
						}
					}
					else {
						tempPriority = 5;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Shield_Battery){
					tempPriority = 6;
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Gateway){
					tempPriority = 8;
				}

				else if (enemyUnit->getType() == BWAPI::UnitTypes::Terran_SCV){
					if (enemyUnit->isConstructing()) {
						tempPriority = 1;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Terran_Supply_Depot){
					if (enemyUnit->isCompleted()) {
						tempPriority = 3;
					}
					else {
						tempPriority = 5;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Terran_Bunker){
					if (enemyUnit->isCompleted()) {
						tempPriority = 9;
					}
					else {
						tempPriority = 4;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Terran_Barracks){
					tempPriority = 8;
				}

				else if (enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Creep_Colony){
					if (enemyUnit->isCompleted()) {
						tempPriority = 5;
					}
					else {
						tempPriority = 2;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Sunken_Colony){
					if (enemyUnit->isCompleted()) {
						tempPriority = 7;
					}
					else {
						tempPriority = 1;
					}
				}
				else if (enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Spawning_Pool){
					tempPriority = 9;
				}

				if (minPriority > tempPriority) {
					minPriority = tempPriority;
					mostUrgentTarget = enemyUnit;
				}
			}
		}
	}

	return mostUrgentTarget;
}

bool Strategy_CombatTaskManager::isImpossibleToWinTheCombat()
{
	bool isImpossibleToWin = false;

	int dangerousUnitCount = 0;

	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(StrategyManager::Instance().enemyPlayer)) {
		BWAPI::Unit enemyUnit = it.first;
		UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.lastHealth == 0) {
			continue;
		}

		if (enemyUnitInfo.completed == true && enemyUnitInfo.lastHealth > 0) {

			if (enemyUnitInfo.type.canAttack() && enemyUnitInfo.type.isWorker() == false) {
				dangerousUnitCount++;
			}

			if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Vulture
				|| enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
				|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Dragoon
				|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Hydralisk)
			{
				dangerousUnitCount+=3;
			}

			if (enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Photon_Cannon
				|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Sunken_Colony)
			{
				dangerousUnitCount+=10;
			}

		}
	}

	if (dangerousUnitCount >= 10) {
		isImpossibleToWin = true;
	}

	return isImpossibleToWin;
}

bool Strategy_CombatTaskManager::isEasyToKillEnemyCombatUnitsWithZergling()
{
	Squad* currentSquad = &StrategyManager::Instance().mainCombatZerglingSquad;

	bool isEnemyHasLittleCombatUnit = true;
	if (enemyMarineCount > (int)(currentSquad->unitset.size() / 3)
		|| enemyZealotCount > (int)(currentSquad->unitset.size() / 4)
		|| enemyZerglingCount > (int)(currentSquad->unitset.size()))
	{
		isEnemyHasLittleCombatUnit = false;
	}

	return isEnemyHasLittleCombatUnit;
}


bool Strategy_CombatTaskManager::isTimeToStartAttack() 
{
	int necessaryNumberOfZergling = 12;
	int necessaryNumberOfHydralisk = 12;
	int necessaryNumberOfLurker = 4;
	int necessaryNumberOfUltralisk = 0;
	int necessaryNumberOfQueen = 1;
	int necessaryNumberOfDefiler = 1;

	//    
	if (StrategyManager::Instance().myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush) 
	{
		return true;
	}

	if (StrategyManager::Instance().myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_Front_Ground_Rush) 
	{
		if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Only) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 0;
			necessaryNumberOfLurker = 0;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 0;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 16;
			necessaryNumberOfLurker = 0;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 0;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Defiler) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 24;
			necessaryNumberOfLurker = 0;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 2;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Lurker) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 16;
			necessaryNumberOfLurker = 4;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 0;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Hydralisk_Lurker_Defiler) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 24;
			necessaryNumberOfLurker = 8;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 2;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Defiler) {
			necessaryNumberOfZergling = 32;
			necessaryNumberOfHydralisk = 0;
			necessaryNumberOfLurker = 8;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 2;
		}
		else if (StrategyManager::Instance().myCurrentBuildStrategy == BuildStrategy::Zerg_Build_Zergling_Lurker_Mutalisk) {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 0;
			necessaryNumberOfLurker = 8;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 0;
		}
		else {
			necessaryNumberOfZergling = 20;
			necessaryNumberOfHydralisk = 24;
			necessaryNumberOfLurker = 8;
			necessaryNumberOfUltralisk = 0;
			necessaryNumberOfQueen = 0;
			necessaryNumberOfDefiler = 0;
		}

	}
	else if (StrategyManager::Instance().myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_Front_Defense_Mutalisk_BackRush) 
	{
		necessaryNumberOfZergling = 20;
		necessaryNumberOfHydralisk = 16;
		necessaryNumberOfLurker = 4;
		necessaryNumberOfUltralisk = 0;
		necessaryNumberOfQueen = 0;
		necessaryNumberOfDefiler = 0;
	}

	//   ּ  ̻ 
	if ((int)(StrategyManager::Instance().mainCombatZerglingSquad.unitset.size()) >= necessaryNumberOfZergling
		&& (int)(StrategyManager::Instance().mainCombatHydraliskSquad.unitset.size()) >= necessaryNumberOfHydralisk
		&& (int)(StrategyManager::Instance().mainCombatLurkerSquad.unitset.size()) >= necessaryNumberOfLurker
		&& (int)(StrategyManager::Instance().mainCombatUltraliskSquad.unitset.size()) >= necessaryNumberOfHydralisk
		&& (int)(StrategyManager::Instance().mainCombatQueenSquad.unitset.size()) >= necessaryNumberOfQueen
		&& (int)(StrategyManager::Instance().mainCombatDefilerSquad.unitset.size()) >= necessaryNumberOfDefiler)
	{

		if (necessaryNumberOfQueen > 0) {
			bool isQueenHasEnoughEnergy = false;
			for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
				if (unit != nullptr && unit->exists() && unit->getType() == BWAPI::UnitTypes::Zerg_Queen && unit->getEnergy() >= 100) {
					isQueenHasEnoughEnergy = true;
					return false;
					break;
				}
			}
		}

		if (necessaryNumberOfDefiler > 0) {
			bool isDefilerHasEnoughEnergy = false;
			for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
				if (unit != nullptr && unit->exists() && unit->getType() == BWAPI::UnitTypes::Zerg_Defiler && unit->getEnergy() >= 100) {
					isDefilerHasEnoughEnergy = true;
					return false;
					break;
				}
			}
		}
		return true;
	}
	else if (StrategyManager::Instance().mainCombatZerglingSquad.unitset.size()
		+ StrategyManager::Instance().mainCombatHydraliskSquad.unitset.size()
		+ StrategyManager::Instance().mainCombatLurkerSquad.unitset.size() > 30) 
	{
		return true;
	}

	return false;
}


bool Strategy_CombatTaskManager::isTimeToRetreatFromCombat()
{
	//   ڰ 10 ̸  
	if (StrategyManager::Instance().mainCombatZerglingSquad.unitset.size()
		+ StrategyManager::Instance().mainCombatHydraliskSquad.unitset.size()
		+ StrategyManager::Instance().mainCombatLurkerSquad.unitset.size() < 10 ) 
	{
		return true;
	}

	return false;
}


BWTA::BaseLocation* Strategy_CombatTaskManager::getWeakestEnemyBaseLocationForGroundCombatUnit()
{
	BWTA::BaseLocation* targetBaseLocation = nullptr;

	//  2,3Ƽ  ű⸦ 
	for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().enemyPlayer)) {
		if (StrategyManager::Instance().enemyMainBaseLocation != baseLocation
			&& StrategyManager::Instance().enemyFirstExpansionBaseLocation != baseLocation) {
			targetBaseLocation = baseLocation;
			break;
		}
	}

	//   ո  ո 
	if (targetBaseLocation == nullptr) {
		for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().enemyPlayer)) {
			if (StrategyManager::Instance().enemyFirstExpansionBaseLocation == baseLocation) {
				targetBaseLocation = baseLocation;
			}
		}
	}

	//     
	if (targetBaseLocation == nullptr) {
		targetBaseLocation = StrategyManager::Instance().enemyMainBaseLocation;
	}

	return targetBaseLocation;

}

int Strategy_CombatTaskManager::getMyUnitCount(BWAPI::Position from, int radius)
{
	int count = 0;
	for (auto & unit : BWAPI::Broodwar->getUnitsInRadius(from, radius)) {
		if (unit->getPlayer() == InformationManager::Instance().selfPlayer) {
			if (unit->getType().isWorker() == false) {
				count++;
			}
		}
	}
	return count;
}

BWAPI::Position Strategy_CombatTaskManager::getAssemblePositionForGroundAttack(BWAPI::Position from, BWAPI::Position to)
{
	if (from.isValid() == false || to.isValid() == false) {
		return BWAPI::Positions::None;
	}

	BWAPI::Position targetPosition = BWAPI::Positions::None;
	BWAPI::TilePosition targetTilePosition = BWAPI::TilePositions::None;

	/*
	std::list<BWTA::Chokepoint*> chokepointList = BWTA::getShortestPath2(
		BWAPI::TilePosition(StrategyManager::Instance().frontlinePosition.x / TILE_SIZE, StrategyManager::Instance().frontlinePosition.y / TILE_SIZE),
		BWAPI::TilePosition(finalTargetPosition));

	while (chokepointList.size() > 2) {
		chokepointList.pop_front();
	}
	BWTA::Chokepoint* targetChokepoint = chokepointList.front();
	targetPosition = targetChokepoint->getCenter();
	*/

	std::vector<BWAPI::TilePosition> tileVector = BWTA::getShortestPath( BWAPI::TilePosition(from), BWAPI::TilePosition(to));

	if (tileVector.size() > 60) {
		targetTilePosition = tileVector[tileVector.size() - 30];
	}
	else {
		targetTilePosition = tileVector[tileVector.size() / 2];
	}
	targetPosition = BWAPI::Position(targetTilePosition);

	return targetPosition;

}

int Strategy_CombatTaskManager::getAttractionToAttackWithMutalisk(BWTA::BaseLocation* baseLocation)
{
	if (baseLocation == nullptr) {
		return 0;
	}

	int workerCount = 0;
	int resourceDepotCount = 0;
	int buildingCount = 0;

	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
		BWAPI::Unit enemyUnit = it.first;
		UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.type.isBuilding() && BWTA::getRegion(enemyUnitInfo.lastPosition) == BWTA::getRegion(baseLocation->getPosition())) {
			if (enemyUnitInfo.type.canAttack() == false) {
				buildingCount++;
			}
		}
		if (enemyUnitInfo.lastPosition.getDistance(baseLocation->getPosition()) <= 8 * TILE_SIZE) {
			if (enemyUnitInfo.type.isResourceDepot()) {
				resourceDepotCount++;
			}
			else if (enemyUnitInfo.type.isWorker()) {
				workerCount++;
			}
		}		
	}

	return workerCount + resourceDepotCount + buildingCount;
}

int Strategy_CombatTaskManager::getDifficultyToAttackWithMutalisk(BWTA::BaseLocation* baseLocation)
{
	if (baseLocation == nullptr) {
		return 10000;
	}

	//    Ǵ
	bool isTooStrongThisEnemy = false;

	Squad* currentSquad = &StrategyManager::Instance().mainCombatMutaliskSquad;
	
	int defenseBuildingTurretCount = 0;
	int defenseBuildingBunkerCount = 0;
	int defenseBuildingCannonCount = 0;
	int defenseBuildingSporeCount = 0;
	int airCombatUnitMarineCount = 0;
	int airCombatUnitGoliathCount = 0;
	int airCombatUnitWraithCount = 0;
	int airCombatUnitDragoonCount = 0;
	int airCombatUnitCorsairCount = 0;
	int airCombatUnitHydraliskCount = 0;
	int airCombatUnitMutaliskCount = 0;

	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
		BWAPI::Unit enemyUnit = it.first;
		UnitInfo & enemyUnitInfo = it.second;
		
		// Ÿ
		// , ͷ, ݷδ 7
		//  4 + 2
		//  4 + 1
		//  4 + 1
		//unit->getType().groundWeapon().maxRange
		if (enemyUnitInfo.lastPosition.getDistance(baseLocation->getPosition()) <= 8 * TILE_SIZE) {

			if (enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Photon_Cannon) {
				defenseBuildingCannonCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Missile_Turret)
			{
				defenseBuildingTurretCount++;
			}
			// Ŀ 2 
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Bunker) {
				defenseBuildingBunkerCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Spore_Colony) {
				defenseBuildingSporeCount++;
			}
		}
		else if (enemyUnitInfo.lastPosition.getDistance(baseLocation->getPosition()) <= 8 * TILE_SIZE) {
			if (enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Dragoon){
				airCombatUnitGoliathCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Hydralisk){
				airCombatUnitHydraliskCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Mutalisk){
				airCombatUnitMutaliskCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Marine){
				airCombatUnitMarineCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Wraith){
				airCombatUnitWraithCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Goliath)
			{
				airCombatUnitGoliathCount++;
			}
			else if (enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Corsair) {
				airCombatUnitCorsairCount++;
			}
		}
	}

	// TODO : ӽŷ ?
	// Ż 8 - ͷ 3
	// Ż 12 - ͷ 4
	if ((int)(currentSquad->unitset.size()) < 8) {
		if (defenseBuildingTurretCount > 0
			|| defenseBuildingBunkerCount > 0
			|| defenseBuildingCannonCount > 0
			|| defenseBuildingSporeCount > 0
			|| airCombatUnitMarineCount > 0
			|| airCombatUnitGoliathCount > 0
			|| airCombatUnitWraithCount > 0
			|| airCombatUnitDragoonCount > 0
			|| airCombatUnitCorsairCount > 0
			|| airCombatUnitHydraliskCount > 0
			|| airCombatUnitMutaliskCount > 0)
		{
			isTooStrongThisEnemy = true;
		}
	}
	else if ((int)(currentSquad->unitset.size()) <= 10) {
		if (defenseBuildingTurretCount > 2
			|| defenseBuildingBunkerCount > 0
			|| defenseBuildingCannonCount > 2
			|| defenseBuildingSporeCount > 2
			|| airCombatUnitMarineCount > 3
			|| airCombatUnitGoliathCount > 3
			|| airCombatUnitWraithCount > 3
			|| airCombatUnitDragoonCount > 2
			|| airCombatUnitCorsairCount > 2
			|| airCombatUnitHydraliskCount > 3
			|| airCombatUnitMutaliskCount > 4)
		{
			isTooStrongThisEnemy = true;
		}
	}
	else if ((int)(currentSquad->unitset.size()) <= 12) {
		if (defenseBuildingTurretCount > 3
			|| defenseBuildingBunkerCount > 2
			|| defenseBuildingCannonCount > 3
			|| defenseBuildingSporeCount > 3
			|| airCombatUnitMarineCount > 5
			|| airCombatUnitGoliathCount > 3
			|| airCombatUnitWraithCount > 4
			|| airCombatUnitDragoonCount > 3
			|| airCombatUnitCorsairCount > 3
			|| airCombatUnitHydraliskCount > 4
			|| airCombatUnitMutaliskCount > 6)
		{
			isTooStrongThisEnemy = true;
		}
	}
	else if ((int)(currentSquad->unitset.size()) <= 14) {
		if (defenseBuildingTurretCount > 3
			|| defenseBuildingBunkerCount > 3
			|| defenseBuildingCannonCount > 4
			|| defenseBuildingSporeCount > 3
			|| airCombatUnitMarineCount > 6
			|| airCombatUnitGoliathCount > 4
			|| airCombatUnitWraithCount > 5
			|| airCombatUnitDragoonCount > 4
			|| airCombatUnitCorsairCount > 4
			|| airCombatUnitHydraliskCount > 6
			|| airCombatUnitMutaliskCount > 8)
		{
			isTooStrongThisEnemy = true;
		}
	}
	else if ((int)(currentSquad->unitset.size()) > 14) {
		isTooStrongThisEnemy = false;
	}

	int difficulty = defenseBuildingTurretCount + defenseBuildingBunkerCount + defenseBuildingCannonCount + defenseBuildingSporeCount
		+ airCombatUnitMarineCount + airCombatUnitGoliathCount + airCombatUnitWraithCount + airCombatUnitDragoonCount
		+ airCombatUnitCorsairCount + airCombatUnitHydraliskCount + airCombatUnitMutaliskCount;

	if (isTooStrongThisEnemy) {
		return 10000;
	}
	else {
		return difficulty;
	}
}

BWTA::BaseLocation* Strategy_CombatTaskManager::getWeakestEnemyBaseLocationForMutalisk()
{
	BWTA::BaseLocation * targetBaseLocation = nullptr;

	int minDefense = 1000000000;
	int tempDefense = 0;
	for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().enemyPlayer)) {
		int attraction = getAttractionToAttackWithMutalisk(baseLocation);
		if (attraction > 0) {
			tempDefense = getDifficultyToAttackWithMutalisk(baseLocation);
			if (tempDefense < 10000) {
				//   ?
				//tempDistance = currentSquad->unitset.getPosition().getDistance(baseLocation->getPosition());
				// ϱ   
				if (minDefense > tempDefense) {
					minDefense = tempDefense;
					targetBaseLocation = baseLocation;
				}
			}
		}
	}

	return targetBaseLocation;
}

BWAPI::Position Strategy_CombatTaskManager::getTargetPositionInMapToAttackWithMutalisk()
{
	BWAPI::Position targetPosition = BWAPI::Positions::None;
	int targetUnitPriority = 10000;

	int targetUnitSearchRadius = 8 * TILE_SIZE;

	// ̴  ֵ ߿ ˻
	for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

		bool isOutOfEnemyBaseLocationUnit = true;
		for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().enemyPlayer)) {
			if (BWTA::getRegion(baseLocation->getPosition()) == BWTA::getRegion(enemyUnit->getPosition())) {
				isOutOfEnemyBaseLocationUnit = false;
				break;
			}
		}

		if (isOutOfEnemyBaseLocationUnit) {
			int airAttackUnitCount = 0;
			for (auto & unit : BWAPI::Broodwar->getUnitsInRadius(enemyUnit->getPosition(), targetUnitSearchRadius)) {
				if (unit->getPlayer() == InformationManager::Instance().enemyPlayer) {
					BWAPI::WeaponType weaponType = unit->getType().airWeapon();
					if (weaponType != BWAPI::WeaponTypes::None && weaponType.targetsAir()) {
						airAttackUnitCount++;
					}
				}
			}

			if (airAttackUnitCount <= 2) {

				int currentUnitPriority = (enemyUnit->getType().mineralPrice() + enemyUnit->getType().gasPrice()) * (-1);

				if (targetUnitPriority > currentUnitPriority) {
					targetUnitPriority = currentUnitPriority;
					targetPosition = enemyUnit->getPosition();
				}
			}
		}
	}

	return targetPosition;
}


void Strategy_CombatTaskManager::moveMutaliskSquad(BWAPI::Position finalTargetPosition, bool isToAttackBaseLocation)
{
	Squad* currentSquad = &StrategyManager::Instance().mainCombatMutaliskSquad;

	int minRadiusForMove = 20 * TILE_SIZE;

	BWAPI::TilePosition finalTargetTilePosition = BWAPI::TilePosition(finalTargetPosition);
	// Ż   
	BWAPI::Unit targetUnit = nullptr;

	//   ַ ٴϴ 
	std::vector<BWAPI::TilePosition> mainGroundPath = BWTA::getShortestPath(StrategyManager::Instance().enemyMainBaseLocation->getTilePosition(),
		StrategyManager::Instance().myFirstExpansionBaseLocation->getTilePosition());
	

	//  Ż   
	for (auto & unit : currentSquad->unitset) {

		if (unit == nullptr || unit->exists() == false || unit->getType().canAttack() == false) {
			continue;
		}

		Mission* unitMission = currentSquad->getUnitMission(unit);
		BWAPI::Position currentUnitPosition = unit->getPosition();
		BWAPI::TilePosition currentUnitTilePosition = unit->getTilePosition();

		BWAPI::Position tempPosition = BWAPI::Positions::None;
		BWAPI::Position targetPosition = BWAPI::Positions::None;

		bool hasCommanded = false;

		//   BaseLocation  , 
		if (isToAttackBaseLocation) {

			//   ó BaseLocation  targetPosition  ´
			double minDistance = 1000000000;
			double tempDistance = 0;

			int minDangerLevel = 1000000000;
			int tempDangerLevel = 0;

			for (auto & it : StrategyManager::Instance().baseLocationStatusMap) {
				BWTA::BaseLocation* baselocation = it.first;
				LocationInfo& locationInfo = it.second;

				//   ƴ BaseLocation
				if (it.second.locationStatus == LocationStatus::Enemy_MainBase
					|| it.second.locationStatus == LocationStatus::Enemy_Occupied)
				{
					continue;
				}

				//  ո ƴ BaseLocation
				if (baselocation == StrategyManager::Instance().enemyFirstExpansionBaseLocation) {
					continue;
				}

				//  ġ ٷ    ͺ, BaseLocation       : Ÿ ϸ 
				//if (currentUnitPosition.getDistance(finalTargetPosition) < baselocation->getPosition().getDistance(finalTargetPosition)) {
				//	continue;
				//}

				//    ֵ鿡   ʴ BaseLocation 
				BWAPI::TilePosition tempTilePosition = baselocation->getTilePosition();
				int tempDangerLevel = StrategyManager::Instance().confidenceMapForMutalisk->getDangerLevelToFlyer(currentUnitTilePosition, BWAPI::TilePosition(tempTilePosition));

				if (tempDangerLevel > 4000) {
					continue;
				}
				
				// ׷   finalTargetPosition    BaseLocation
				tempDistance = baselocation->getPosition().getDistance(finalTargetPosition);
				if (minDistance > tempDistance) {
					minDistance = tempDistance;
					tempPosition = baselocation->getPosition();
				}
			}

			// ׷ BaseLocation  ְ,  ġ ٷ    ͺ, BaseLocation      ش BaseLocation  ̵
			if (tempPosition != BWAPI::Positions::None && unit->getDistance(finalTargetPosition) > tempPosition.getDistance(finalTargetPosition)) {
				targetPosition = tempPosition;
			}
			// ׷ BaseLocation  ٸ,  ֵ鿡   ΰ ް ְų, ̹  κ   BaseLocation  ߴٴ 
			else {

				tempPosition = finalTargetPosition;

				//   Ÿ  targetPosition    ȴ

				//   Ÿ ָ  targetPosition    ڸ Ͽ    ̵ϰ Ѵ
				/*
				if (currentUnitPosition.getDistance(finalTargetPosition) > 10 * TILE_SIZE) {

					double angle = (double)(BWAPI::Broodwar->mapHeight()) / (double)(BWAPI::Broodwar->mapWidth());
					
					if (currentUnitPosition.y > angle * (double)currentUnitPosition.x) {
						if (currentUnitPosition.y < BWAPI::Broodwar->mapHeight() - angle * (double)currentUnitPosition.x) {
							//BWAPI::Broodwar->drawTextMap(currentUnitPosition.x * TILE_SIZE, currentUnitPosition.y * TILE_SIZE, "Left");
							tempPosition.x = TILE_SIZE;
						}
						else {
							//BWAPI::Broodwar->drawTextMap(currentUnitPosition.x * TILE_SIZE, currentUnitPosition.y * TILE_SIZE, "Down");
							tempPosition.y = (BWAPI::Broodwar->mapHeight() - 1) * TILE_SIZE;
						}
					}
					else {
						if (currentUnitPosition.y < BWAPI::Broodwar->mapHeight() - angle * (double)currentUnitPosition.x) {
							//BWAPI::Broodwar->drawTextMap(currentUnitPosition.x * TILE_SIZE, currentUnitPosition.y * TILE_SIZE, "Upper");
							tempPosition.y = TILE_SIZE;
						}
						else {
							//BWAPI::Broodwar->drawTextMap(currentUnitPosition.x * TILE_SIZE, currentUnitPosition.y * TILE_SIZE, "Right");
							tempPosition.x = (BWAPI::Broodwar->mapWidth() - 1) * TILE_SIZE;
						}
					}
				}
				*/

				targetPosition = tempPosition;
			}
		}
		//   BaseLocation  ƴ  (Ư  Ȥ ǹ Ϸ ų,  safe position  ̵ϴ ) 
		else {
			targetPosition = finalTargetPosition;
		}


		//   ΰ  ( ؾ   ְڴ,  ̱  ְڴ) üũѴ
		// TODO :  ġ ߽ ϴ  ׷  45 ٲ㺸  ȸ ߰ ã´
		/*
		BWAPI::Position midPosition = targetPosition;
		int tempDangerLevel = 0;
		double theta = 0;
		double distance = 0;
		for (int i = 0; i < 100; i++) {

			if (i != 0) {
				midPosition = BWAPI::Position(targetPosition.x + rand() % (20 * TILE_SIZE) - 10 * TILE_SIZE, targetPosition.y + rand() % (20 * TILE_SIZE) - 10 * TILE_SIZE);
			}

			if (midPosition.isValid()) {
				tempDangerLevel = StrategyManager::Instance().confidenceMapForMutalisk->getDangerLevelToFlyer(currentUnitTilePosition, BWAPI::TilePosition(midPosition));
				if (tempDangerLevel < 4000) {
					targetPosition = midPosition;
					break;
				}
			}	
		}
		*/

		//   ų
		//  Ÿ    (Ÿ 3 Tile) ̱  ְڴ Ǵغ
		// ̱  ְڴٸ ο, 
		// ̱  ڴٸ ݱ ȸ ߰   ׳     ̵Ѵ

		//  ٸ Region ̸
		if (BWTA::getRegion(unit->getPosition()) != BWTA::getRegion(finalTargetPosition)) {
		//if (currentUnitPosition.getDistance(finalTargetPosition) > 7 * TILE_SIZE) {
			
			if (targetPosition != BWAPI::Positions::None) {
				currentSquad->setUnitMission(unit, Mission(MissionType::MovePoint, targetPosition));
			}
		}
		//   Region ̸    ϰ Ѵ
		else {
			targetUnit = getAttractiveUnitToAttackForMutalisk(unit);

			if (targetUnit != nullptr) {
				currentSquad->setUnitMission(unit, Mission(MissionType::Attack, targetUnit));
			}
			else {
				currentSquad->setUnitMission(unit, Mission(MissionType::AttackMove, targetPosition));
			}
		}
	}
}

BWAPI::Unit Strategy_CombatTaskManager::getAttractiveUnitToAttackForMutalisk(BWAPI::Unit mutalisk)
{
	if (mutalisk == nullptr) {
		return nullptr;
	}

	//    ִ,  켱  (Priority ڰ )  ġ ã´

	BWAPI::Unit targetUnit = nullptr;

	int minPriority = 1000000000;
	int tempPriority = 0;
	double minDistance = 1000000000;
	double tempDistance = 0;

	for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {

		if (enemyUnit == nullptr || enemyUnit->exists() == false || enemyUnit->isVisible() == false || enemyUnit->getHitPoints() <= 0) {
			continue;
		}
		if (enemyUnit->getPlayer() != StrategyManager::Instance().enemyPlayer) {
			continue;
		}
		if (BWTA::getRegion(mutalisk->getPosition()) != BWTA::getRegion(enemyUnit->getPosition())) {
			continue;
		}

		// 켱    Ѵ
		tempPriority = getAttackPriority(enemyUnit);

		if (minPriority > tempPriority) {
			minPriority = tempPriority;
			targetUnit = enemyUnit;
		}
		else if (minPriority == tempPriority) {
			tempDistance = enemyUnit->getDistance(mainCombatMutaliskSquadCenterPosition);
			if (minDistance > tempDistance) {
				minDistance = tempDistance;
				targetUnit = enemyUnit;
			}
		}
	}

	return targetUnit;
}

BWAPI::Position Strategy_CombatTaskManager::getTargetPositionToAttackWithMutalisk()
{
	BWAPI::Position targetPosition = BWAPI::Positions::None;

	int targetUnitSearchRadius = 8 * TILE_SIZE;

	int minPriority = 1000000000;
	int tempPriority = 0;

	double minDistance = 1000000000;
	double tempDistance = 0;

	// ̴  ֵ ߿ ˻
	for (auto & enemyUnit : BWAPI::Broodwar->enemy()->getUnits()) {
		if (enemyUnit == nullptr || enemyUnit->exists() == false) continue;

		// 켱    Ѵ
		tempPriority = getAttackPriority(enemyUnit);

		if (minPriority > tempPriority) {
			minPriority = tempPriority;
			targetPosition = enemyUnit->getPosition();
		}
		else if (minPriority == tempPriority) {
			tempDistance = enemyUnit->getDistance(mainCombatMutaliskSquadCenterPosition);
			if (minDistance > tempDistance) {
				minDistance = tempDistance;
				targetPosition = enemyUnit->getPosition();
			}
		}
	}

	return targetPosition;

}


int Strategy_CombatTaskManager::getAttackPriority(BWAPI::Unit enemyUnit)
{
	if (enemyUnit == nullptr || enemyUnit->exists() == false) return 10000;

	//  ϲ ó  ǹ / 
	// Ÿ
	// , ͷ, ݷδ 7
	//  4 + 2
	//  4 + 1
	//  4 + 1
	//unit->getType().groundWeapon().maxRange

	int currentUnitPriority = 99;

	int minDamagePerSecond = 1000000000;
	int tempDamagePerSecond = 0;

	BWAPI::TilePosition enemyUnitTilePosition = enemyUnit->getTilePosition();
	ConfidenceMapCell & enemyCell = StrategyManager::Instance().confidenceMapForMutalisk->GetCell(enemyUnitTilePosition);
	tempDamagePerSecond = enemyCell.airDamagePerSecond;

	// Ǽ ϲ ֿ켱
	if (enemyUnit->getType().isWorker()) {
		if (enemyUnit->isConstructing()) {
			currentUnitPriority = 1;
		}
		else {
			currentUnitPriority = 15;
		}
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_High_Templar
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Defiler
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel)
	{
		currentUnitPriority = 0;
	}
	else if (enemyUnit->getType().isBuilding()
		&& enemyUnit->isCompleted() == false
		&& (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Forge
		|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Photon_Cannon
		|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Templar_Archives
		|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Stargate
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Missile_Turret
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Bunker
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Starport
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Creep_Colony
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Evolution_Chamber
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Spire
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Spore_Colony)) {
		currentUnitPriority = 2;
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Photon_Cannon
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Missile_Turret) {
		currentUnitPriority = 10;
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Dragoon
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Mutalisk
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Marine
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Wraith
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Goliath) {
		currentUnitPriority = 5;
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Forge
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Evolution_Chamber)
	{
		currentUnitPriority = 30;
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Terran_Bunker
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Spore_Colony) {
		currentUnitPriority = 80;
	}
	else if (enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Corsair
		|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Archon
		|| enemyUnit->getType() == BWAPI::UnitTypes::Protoss_Carrier
		|| enemyUnit->getType() == BWAPI::UnitTypes::Zerg_Devourer
		|| enemyUnit->getType() == BWAPI::UnitTypes::Terran_Battlecruiser) {
		currentUnitPriority = 80;
	}
	else if (enemyUnit->getType().isBuilding()) {
		currentUnitPriority = 90;
	}
	else {
		currentUnitPriority = 50;
	}

	//     ִ ֵ    ̷
	if (tempDamagePerSecond > 1500) {
		currentUnitPriority += 30;
	}

	return currentUnitPriority;
}


void Strategy_CombatTaskManager::swarmTest()
{
	/*
	// Swarm AI
	// ٷ Ѹ ̵ϴ  
	for (auto & unit : squad) {

		//  ؼ   
		if (!unit->exists()) continue;

		BWAPI::Unitset enemyUnits;
		MapGrid::Instance().getUnitsNear(enemyUnits, unit->getPosition(), 10 * TILE_SIZE, false, true);

		//  ӹ  ݽŲ
		if (unit->isAttacking() || enemyUnits.size() > 0) {
			if (unit->canAttack()) {
				Micro::SmartAttackMove(unit, targetAttackPosition);
			}
			else {
				Micro::SmartMove(unit, targetAttackPosition);
			}
		}
		// ̵ ֿ ؼ
		else {
			//  ִ  ̵Ų
			if (unit->getVelocityX() == 0 && unit->getVelocityY() == 0) { // isMoving() == false) { 
				if (unit->canAttack()) {
					Micro::SmartAttackMove(unit, targetAttackPosition);
				}
				else {
					Micro::SmartMove(unit, targetAttackPosition);
				}
			}
			//  ̵̸ ̵  Ѵ
			else {
				BWAPI::Position unitCurrentPosition = unit->getPosition();				// pixel .  ġ
				double unitVelocityX = unit->getVelocityX();							// pixels in frame
				double unitVelocityY = unit->getVelocityY();
				double unitVelocityAngle = std::atan2(unitVelocityY * (-1.0), unitVelocityX + 0.0001); //  . Y Ųٷ
				double unitVelocityLength = std::sqrt(unitVelocityX*unitVelocityX + unitVelocityY*unitVelocityY);

				// TODO : neighbor   ǹ ƴ,  ֵ ߿ ؾѴ
				// neighbor  ݰ 8 Ÿ  Ѵ
				BWAPI::Unitset neighborUnits;
				neighborUnits = BWAPI::Broodwar->getUnitsInRadius(unitCurrentPosition, 8 * TILE_SIZE, BWAPI::Filter::IsOwned && !BWAPI::Filter::IsBuilding);
				//MapGrid::Instance().getUnitsNear(neighborUnits, unitCurrentPosition, 8 * TILE_SIZE, true, false);

				if (neighborUnits.size() == 0) continue;

				std::pair<double, double> unitNextProperPosition;

				//  ,  ֵ 浹 Ѵ 
				// ٸ ֵ 浹ϰ ɰŶ,  ٲ۴
				if (true) {
					if (!unit->isFlying()) {

						std::pair<double, double> unitNextAnticipatedPosition;					// pixel . 8 frame  ġ. 

						//  ֵ 浹ϰ ɰŶ,  ð 30 ٲ㺻 (0, 15, -15, 30, -30, ..., 90, -90) //, 135, -135, 180)
						//   ٲ ׻ 浹 ̶, Ѵ
						bool properDirectionFound = true;
						bool willCollide = false;
						double angleMultiply = 0;

						while (true) {

							//  neighbor  浹 ʴ´ٸ properDirectionFound = true  ȴ
							properDirectionFound = true;
							for (auto & neighbor : neighborUnits) {

								if (unit == neighbor
									|| neighbor->getType().isFlyer()
									|| (neighbor->getType().isBuilding() && neighbor->isFlying())) {
									continue;
								}

								//for (double i = 1; i < 8; i += 1.0) {
								double i = 8;
								unitNextAnticipatedPosition.first = unitCurrentPosition.x + unitVelocityLength * i * cos(unitVelocityAngle + (M_PI / 6.0)*angleMultiply);
								unitNextAnticipatedPosition.second = unitCurrentPosition.y - unitVelocityLength * i * sin(unitVelocityAngle + (M_PI / 6.0)*angleMultiply);

								if (unitNextAnticipatedPosition.first >= neighbor->getLeft() && unitNextAnticipatedPosition.first <= neighbor->getRight()
									&& unitNextAnticipatedPosition.second >= neighbor->getTop() && unitNextAnticipatedPosition.second <= neighbor->getBottom())
								{
									//std::cout << "Swarm move : unit " << unit->getID() << " (" << unit->getTilePosition().x << ", " << unit->getTilePosition().y 
									//	<< ") will collide with " << neighbor->getID() << " at (" << (double)(unitNextAnticipatedPosition.first / 32.0) << ", " << (double)(unitNextAnticipatedPosition.second / 32.0) << ")" << std::endl;

									willCollide = true;
									properDirectionFound = false;
									//break;
								}
								//}

								if (willCollide) {
									break;
								}
							}

							if (properDirectionFound) {
								break;
							}

							if (angleMultiply == 0) angleMultiply = 1;
							else if (angleMultiply == 1) angleMultiply = -1;
							else if (angleMultiply == -1) angleMultiply = 2;
							else if (angleMultiply == 2) angleMultiply = -2;
							else if (angleMultiply == -2) angleMultiply = 3;
							else if (angleMultiply == 3) angleMultiply = -3;
							//else if (angleMultiply == -3) angleMultiply = 4;
							//else if (angleMultiply == 4) angleMultiply = -4;
							//else if (angleMultiply == -4) angleMultiply = 5;
							//else if (angleMultiply == 5) angleMultiply = -5;
							//else if (angleMultiply == -5) angleMultiply = 6;
							//else if (angleMultiply == 6) angleMultiply = -6;
							else {
								break;
							}
						}

						// 浹   浹 ȸ  ִ  ̵Ѵ
						if (willCollide == true) {
							if (properDirectionFound == true) {

								unitNextProperPosition.first = unitCurrentPosition.x + unitVelocityLength*cos(unitVelocityAngle + (M_PI / 12.0)*angleMultiply) * 24.0; // ϱ  ϴ  ʹ ª Ÿġ ݹ ϴϱ
								unitNextProperPosition.second = unitCurrentPosition.y - unitVelocityLength*sin(unitVelocityAngle + (M_PI / 12.0)*angleMultiply) * 24.0;

								//std::cout << "Swarm move : unit " << unit->getID() << " (" << unit->getTilePosition().x << ", " << unit->getTilePosition().y << 
								//	") change Target To (" << (double)(unitNextProperPosition.first / 32.0) << ", " << (double)(unitNextProperPosition.second / 32.0) << ")" << std::endl;
								BWAPI::Broodwar->drawCircleMap(unit->getPosition(), 30, BWAPI::Colors::Orange);
								if (unit->canAttack()) {
									Micro::SmartAttackMove(unit, BWAPI::Position((int)unitNextProperPosition.first, (int)unitNextProperPosition.second));
								}
								else {
									Micro::SmartMove(unit, BWAPI::Position((int)unitNextProperPosition.first, (int)unitNextProperPosition.second));
								}
							}
							//   ̵ص  浹ϸ, ׳ stop Ѵ
							else {
								//std::cout << "Swarm move : unit " << unit->getID() << " (" << unit->getTilePosition().x << ", " << unit->getTilePosition().y << 
								//	" will collide -> stop" << std::endl;
								unit->stop();
							}
						}
					}
				}

				//  ֵ   ( )  ̵ϵ Ѵ
				if (false) {
					double averageVelocityX = 0;
					double averageVelocityY = 0;
					for (auto & neighbor : neighborUnits) {
						averageVelocityX += neighbor->getVelocityX();
						averageVelocityY += neighbor->getVelocityY();
					}
					averageVelocityX /= neighborUnits.size();
					averageVelocityY /= neighborUnits.size();

					unitNextProperPosition.first = unitCurrentPosition.x + unitVelocityX + averageVelocityX * 0.1;
					unitNextProperPosition.second = unitCurrentPosition.y + unitVelocityY + averageVelocityY * 0.1;
				}

				// targetAttackPosition   ռ ְ neighbor ֵ ߽ κ ʹ ָ   
				// neighbor ֵ ߽  ̵Ѽ, Բ   Ѵ
				if (true) {

					BWAPI::Position centerOfNeighborUnits = neighborUnits.getPosition();
					double unitDistanceToTargetAttackPosition = unit->getDistance(targetAttackPosition);

					bool isFrontier = true;
					for (auto & neighbor : neighborUnits) {
						if (neighbor->getDistance(targetAttackPosition) < unitDistanceToTargetAttackPosition) {
							isFrontier = false;
						}
					}

					// neighbor ֵ ߿  ռ ְ,
					if (isFrontier) {

						// neighbor ֵ ߽ κ 6 Ÿ ̻ ָ ְų, 
						// neighborUnits Ը  neighborUnits 1~10  4Ÿ, 10~20̸ 6Ÿ  ָ 
						double tileDistanceFromCenter = unit->getDistance(centerOfNeighborUnits) / TILE_SIZE;
						if (tileDistanceFromCenter > 6 || tileDistanceFromCenter > (neighborUnits.size() + 10.0) / 6.0) {

							// neighbor ֵ ߽  unit ġ ׸  60 Ȥ -60 ȸ ġ ̵Ų
							// neighbor ֵ ߽  ̵Űų, Ű ٴ   
							double unitVectorX = unit->getPosition().x - centerOfNeighborUnits.x;
							double unitVectorY = unit->getPosition().y - centerOfNeighborUnits.y;
							double unitVectorAngle = std::atan2(unitVectorY * (-1.0), unitVectorX + 0.0001); //  . Y Ųٷ
							double unitVectorLength = std::max(std::sqrt(unitVectorX*unitVectorX + unitVectorY*unitVectorY), 3.0 * TILE_SIZE);
							unitNextProperPosition.first = centerOfNeighborUnits.x + unitVectorLength*cos(unitVectorAngle + (M_PI / 3.0) * (rand() % 2 == 0 ? 1.0 : -1.0));
							unitNextProperPosition.second = centerOfNeighborUnits.y - unitVectorLength*sin(unitVectorAngle + (M_PI / 3.0) * (rand() % 2 == 0 ? 1.0 : -1.0));

							//std::cout << "Swarm move : " << unit->getType().getName() << " " << unit->getID() << " (" << unit->getTilePosition().x << ", " << unit->getTilePosition().y 
							//	<< ") is too far from centerOfNeighborUnits (" << (double)(centerOfNeighborUnits.x / 32.0) << ", " << (double)(centerOfNeighborUnits.y / 32.0)
							//	<< ") [size=" << neighborUnits.size() 
							//	<< "] so move to (" << (double)(unitNextProperPosition.first / 32.0) << ", " << (double)(unitNextProperPosition.second / 32.0) << ")" << std::endl;
							BWAPI::Broodwar->drawCircleMap(unit->getPosition(), 30, BWAPI::Colors::Yellow);

							if (unit->canAttack()) {
								Micro::SmartAttackMove(unit, BWAPI::Position((int)unitNextProperPosition.first, (int)unitNextProperPosition.second));
								//Micro::SmartAttackMove(unit, centerOfNeighborUnits);
								//unit->stop();
							}
							else {
								Micro::SmartMove(unit, BWAPI::Position((int)unitNextProperPosition.first, (int)unitNextProperPosition.second));
								//Micro::SmartMove(unit, centerOfNeighborUnits);
								//unit->stop();
							}
						}
					}
				}
			}
		}
	}
	*/
}